/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog.constraints;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.error.Error;
import com.google.protobuf.ByteString;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public abstract class BytesConstraint
implements Serializable {
    public abstract boolean check(byte[] var1);

    public abstract Schema.BytesConstraint serialize();

    public static Either<Error.FormatError, BytesConstraint> deserialize_enum(Schema.BytesConstraint c) {
        if (c.getKind() == Schema.BytesConstraint.Kind.EQUAL) {
            return Equal.deserialize(c);
        }
        if (c.getKind() == Schema.BytesConstraint.Kind.IN) {
            return InSet.deserialize(c);
        }
        if (c.getKind() == Schema.BytesConstraint.Kind.NOT_IN) {
            return NotInSet.deserialize(c);
        }
        return API.Left((Object)new Error.FormatError.DeserializationError("invalid Bytes constraint kind"));
    }

    public static final class NotInSet
    extends BytesConstraint
    implements Serializable {
        private final Set<byte[]> value;

        @Override
        public boolean check(byte[] value) {
            return !this.value.contains(value);
        }

        public NotInSet(Set<byte[]> value) {
            this.value = value;
        }

        public String toString() {
            return "not in " + this.value;
        }

        @Override
        public Schema.BytesConstraint serialize() {
            Schema.BytesConstraint.Builder b = Schema.BytesConstraint.newBuilder().setKind(Schema.BytesConstraint.Kind.NOT_IN);
            for (byte[] s : this.value) {
                b.addNotInSet(ByteString.copyFrom((byte[])s));
            }
            return b.build();
        }

        public static Either<Error.FormatError, BytesConstraint> deserialize(Schema.BytesConstraint i) {
            HashSet<byte[]> values = new HashSet<byte[]>();
            for (ByteString l : i.getNotInSetList()) {
                values.add(l.toByteArray());
            }
            if (values.isEmpty()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Bytes constraint"));
            }
            return API.Right((Object)new NotInSet(values));
        }
    }

    public static final class InSet
    extends BytesConstraint
    implements Serializable {
        private final Set<byte[]> value;

        @Override
        public boolean check(byte[] value) {
            return this.value.contains(value);
        }

        public InSet(Set<byte[]> value) {
            this.value = value;
        }

        public String toString() {
            return "in " + this.value;
        }

        @Override
        public Schema.BytesConstraint serialize() {
            Schema.BytesConstraint.Builder b = Schema.BytesConstraint.newBuilder().setKind(Schema.BytesConstraint.Kind.IN);
            for (byte[] s : this.value) {
                b.addInSet(ByteString.copyFrom((byte[])s));
            }
            return b.build();
        }

        public static Either<Error.FormatError, BytesConstraint> deserialize(Schema.BytesConstraint i) {
            HashSet<byte[]> values = new HashSet<byte[]>();
            for (ByteString l : i.getInSetList()) {
                values.add(l.toByteArray());
            }
            if (values.isEmpty()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Bytes constraint"));
            }
            return API.Right((Object)new InSet(values));
        }
    }

    public static final class Equal
    extends BytesConstraint
    implements Serializable {
        private final byte[] value;

        @Override
        public boolean check(byte[] value) {
            return this.value.equals(value);
        }

        public Equal(byte[] value) {
            this.value = value;
        }

        public String toString() {
            return "== " + this.value;
        }

        @Override
        public Schema.BytesConstraint serialize() {
            return Schema.BytesConstraint.newBuilder().setKind(Schema.BytesConstraint.Kind.EQUAL).setEqual(ByteString.copyFrom((byte[])this.value)).build();
        }

        public static Either<Error.FormatError, BytesConstraint> deserialize(Schema.BytesConstraint i) {
            if (!i.hasEqual()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Bytes constraint"));
            }
            return API.Right((Object)new Equal(i.getEqual().toByteArray()));
        }
    }
}

