/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog.constraints;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public abstract class SymbolConstraint
implements Serializable {
    public abstract boolean check(long var1);

    public abstract Schema.SymbolConstraint serialize();

    public static Either<Error.FormatError, SymbolConstraint> deserialize_enum(Schema.SymbolConstraint c) {
        if (c.getKind() == Schema.SymbolConstraint.Kind.IN) {
            return InSet.deserialize(c);
        }
        if (c.getKind() == Schema.SymbolConstraint.Kind.IN) {
            return NotInSet.deserialize(c);
        }
        return API.Left((Object)new Error.FormatError.DeserializationError("invalid Symbol constraint kind"));
    }

    public static final class NotInSet
    extends SymbolConstraint
    implements Serializable {
        public final Set<Long> value;

        @Override
        public boolean check(long value) {
            return !this.value.contains(value);
        }

        public NotInSet(Set<Long> value) {
            this.value = value;
        }

        public String toString() {
            return "not in " + this.value;
        }

        @Override
        public Schema.SymbolConstraint serialize() {
            Schema.SymbolConstraint.Builder b = Schema.SymbolConstraint.newBuilder().setKind(Schema.SymbolConstraint.Kind.NOT_IN);
            for (Long l : this.value) {
                b.addNotInSet(l);
            }
            return b.build();
        }

        public static Either<Error.FormatError, SymbolConstraint> deserialize(Schema.SymbolConstraint i) {
            HashSet<Long> values = new HashSet<Long>();
            for (long l : i.getNotInSetList()) {
                values.add(l);
            }
            if (values.isEmpty()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Symbol constraint"));
            }
            return API.Right((Object)new NotInSet(values));
        }
    }

    public static final class InSet
    extends SymbolConstraint
    implements Serializable {
        public final Set<Long> value;

        @Override
        public boolean check(long value) {
            return this.value.contains(value);
        }

        public InSet(Set<Long> value) {
            this.value = value;
        }

        public String toString() {
            return "in " + this.value;
        }

        @Override
        public Schema.SymbolConstraint serialize() {
            Schema.SymbolConstraint.Builder b = Schema.SymbolConstraint.newBuilder().setKind(Schema.SymbolConstraint.Kind.IN);
            for (Long l : this.value) {
                b.addInSet(l);
            }
            return b.build();
        }

        public static Either<Error.FormatError, SymbolConstraint> deserialize(Schema.SymbolConstraint i) {
            HashSet<Long> values = new HashSet<Long>();
            for (long l : i.getInSetList()) {
                values.add(l);
            }
            if (values.isEmpty()) {
                return API.Left((Object)new Error.FormatError.DeserializationError("invalid Symbol constraint"));
            }
            return API.Right((Object)new InSet(values));
        }
    }
}

