/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.token.builder.Caveat;
import com.clevercloud.biscuit.token.builder.Fact;
import com.clevercloud.biscuit.token.builder.Rule;
import com.clevercloud.biscuit.token.builder.Utils;
import com.clevercloud.biscuit.token.builder.constraints.DateConstraint;
import com.clevercloud.biscuit.token.builder.constraints.StrConstraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class Block {
    long index;
    int symbol_start;
    SymbolTable symbols;
    String context;
    List<com.clevercloud.biscuit.datalog.Fact> facts;
    List<com.clevercloud.biscuit.datalog.Rule> rules;
    List<com.clevercloud.biscuit.datalog.Caveat> caveats;

    public Block(long index, SymbolTable base_symbols) {
        this.index = index;
        this.symbol_start = base_symbols.symbols.size();
        this.symbols = new SymbolTable(base_symbols);
        this.context = "";
        this.facts = new ArrayList<com.clevercloud.biscuit.datalog.Fact>();
        this.rules = new ArrayList<com.clevercloud.biscuit.datalog.Rule>();
        this.caveats = new ArrayList<com.clevercloud.biscuit.datalog.Caveat>();
    }

    public void add_fact(Fact f) {
        this.facts.add(f.convert(this.symbols));
    }

    public void add_rule(Rule rule) {
        this.rules.add(rule.convert(this.symbols));
    }

    public void add_caveat(Caveat caveat) {
        this.caveats.add(caveat.convert(this.symbols));
    }

    public void set_context(String context) {
        this.context = context;
    }

    public com.clevercloud.biscuit.token.Block build() {
        SymbolTable symbols = new SymbolTable();
        for (int i = this.symbol_start; i < this.symbols.symbols.size(); ++i) {
            symbols.add(this.symbols.symbols.get(i));
        }
        return new com.clevercloud.biscuit.token.Block(this.index, symbols, this.context, this.facts, this.rules, this.caveats);
    }

    public void check_right(String right) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.rule("check_right", Arrays.asList(Utils.s(right)), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.s("ambient"), Utils.var("resource"))), Utils.pred("operation", Arrays.asList(Utils.s("ambient"), Utils.s(right))), Utils.pred("right", Arrays.asList(Utils.s("authority"), Utils.var("resource"), Utils.s(right))))));
        this.add_caveat(new Caveat(queries));
    }

    public void resource_prefix(String prefix) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("prefix", Arrays.asList(Utils.var("resource")), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.s("ambient"), Utils.var("resource")))), Arrays.asList(new StrConstraint.Prefix("resource", prefix))));
        this.add_caveat(new Caveat(queries));
    }

    public void resource_suffix(String suffix) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("suffix", Arrays.asList(Utils.var("resource")), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.s("ambient"), Utils.var("resource")))), Arrays.asList(new StrConstraint.Suffix("resource", suffix))));
        this.add_caveat(new Caveat(queries));
    }

    public void expiration_date(Date d) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("expiration", Arrays.asList(Utils.var("date")), Arrays.asList(Utils.pred("time", Arrays.asList(Utils.s("ambient"), Utils.var("date")))), Arrays.asList(new DateConstraint.Before("date", d.getTime() / 1000L))));
        this.add_caveat(new Caveat(queries));
    }
}

