/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.token.builder.Caveat;
import com.clevercloud.biscuit.token.builder.Fact;
import com.clevercloud.biscuit.token.builder.Predicate;
import com.clevercloud.biscuit.token.builder.Rule;
import com.clevercloud.biscuit.token.builder.Term;
import com.clevercloud.biscuit.token.builder.constraints.ConstraintBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Utils {
    public static Fact fact(String name, List<Term> ids) {
        return new Fact(name, ids);
    }

    public static Predicate pred(String name, List<Term> ids) {
        return new Predicate(name, ids);
    }

    public static Rule rule(String head_name, List<Term> head_ids, List<Predicate> predicates) {
        return new Rule(Utils.pred(head_name, head_ids), predicates, new ArrayList<ConstraintBuilder>());
    }

    public static Rule constrained_rule(String head_name, List<Term> head_ids, List<Predicate> predicates, List<ConstraintBuilder> constraints) {
        return new Rule(Utils.pred(head_name, head_ids), predicates, constraints);
    }

    public static Caveat caveat(Rule rule) {
        return new Caveat(rule);
    }

    public static Term integer(long i) {
        return new Term.Integer(i);
    }

    public static Term string(String s) {
        return new Term.Str(s);
    }

    public static Term s(String str) {
        return new Term.Symbol(str);
    }

    public static Term date(Date d) {
        return new Term.Date(d.getTime() / 1000L);
    }

    public static Term var(String name) {
        return new Term.Variable(name);
    }
}

