/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder.constraints;

import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.constraints.Constraint;
import com.clevercloud.biscuit.datalog.constraints.ConstraintKind;
import com.clevercloud.biscuit.datalog.constraints.SymbolConstraint;
import com.clevercloud.biscuit.token.builder.constraints.ConstraintBuilder;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class SymbolConstraint
implements ConstraintBuilder {
    @Override
    public abstract Constraint convert(SymbolTable var1);

    public static class NotInSet
    extends SymbolConstraint {
        String id;
        Set<String> value;

        public NotInSet(String id, Set<String> value) {
            this.id = id;
            this.value = value;
        }

        @Override
        public Constraint convert(SymbolTable symbols) {
            Set<Long> ids = this.value.stream().map(string -> symbols.insert((String)string)).collect(Collectors.toSet());
            return new Constraint(symbols.insert(this.id), new ConstraintKind.Symbol(new SymbolConstraint.NotInSet(ids)));
        }

        public String toString() {
            return "not in \"" + this.value + "\"";
        }
    }

    public static class InSet
    extends SymbolConstraint {
        String id;
        Set<String> value;

        public InSet(String id, Set<String> value) {
            this.id = id;
            this.value = value;
        }

        @Override
        public Constraint convert(SymbolTable symbols) {
            Set<Long> ids = this.value.stream().map(string -> symbols.insert((String)string)).collect(Collectors.toSet());
            return new Constraint(symbols.insert(this.id), new ConstraintKind.Symbol(new SymbolConstraint.InSet(ids)));
        }

        public String toString() {
            return "in \"" + this.value + "\"";
        }
    }
}

