/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.error;

import com.clevercloud.biscuit.error.FailedCheck;
import com.clevercloud.biscuit.error.LogicError;
import io.vavr.control.Option;
import java.util.List;
import java.util.Objects;

public class Error {
    public Option<List<FailedCheck>> failed_checks() {
        return Option.none();
    }

    public static class Parser
    extends Error {
        public final com.clevercloud.biscuit.token.builder.parser.Error error;

        public Parser(com.clevercloud.biscuit.token.builder.parser.Error error) {
            this.error = error;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parser parser = (Parser)o;
            return this.error.equals(parser.error);
        }

        public int hashCode() {
            return this.error.hashCode();
        }

        public String toString() {
            return "Parser{error=" + this.error + "}";
        }
    }

    public static class Timeout
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }

    public static class TooManyIterations
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }

    public static class TooManyFacts
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }

    public static class FailedLogic
    extends Error {
        public final LogicError error;

        public FailedLogic(LogicError error) {
            this.error = error;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailedLogic other = (FailedLogic)o;
            return this.error.equals(other.error);
        }

        public int hashCode() {
            return Objects.hash(this.error);
        }

        public String toString() {
            return "Error.FailedLogic{ error: " + this.error + " }";
        }

        @Override
        public Option<List<FailedCheck>> failed_checks() {
            return this.error.failed_checks();
        }
    }

    public static class Sealed
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }

    public static class MissingSymbols
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }

    public static class SymbolTableOverlap
    extends Error {
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }

    public static class InvalidBlockIndex
    extends Error {
        public final long expected;
        public final long found;

        public InvalidBlockIndex(long expected, long found) {
            this.expected = expected;
            this.found = found;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidBlockIndex other = (InvalidBlockIndex)o;
            return this.expected == other.expected && this.found == other.found;
        }

        public int hashCode() {
            return Objects.hash(this.expected, this.found);
        }

        public String toString() {
            return "Error.InvalidBlockIndex{ expected: " + this.expected + ", found: " + this.found + " }";
        }
    }

    public static class InvalidAuthorityIndex
    extends Error {
        public final long index;

        public InvalidAuthorityIndex(long index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidAuthorityIndex other = (InvalidAuthorityIndex)o;
            return this.index == other.index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        public String toString() {
            return "Error.InvalidAuthorityIndex{ index: " + this.index + " }";
        }
    }

    public static class FormatError
    extends Error {

        public static class Version
        extends FormatError {
            public final int maximum;
            public final int actual;

            public Version(int maximum, int actual) {
                this.maximum = maximum;
                this.actual = actual;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Version version = (Version)o;
                if (this.maximum != version.maximum) {
                    return false;
                }
                return this.actual == version.actual;
            }

            public int hashCode() {
                int result = this.maximum;
                result = 31 * result + this.actual;
                return result;
            }

            public String toString() {
                return "Version{maximum=" + this.maximum + ", actual=" + this.actual + "}";
            }
        }

        public static class BlockSerializationError
        extends FormatError {
            public final String e;

            public BlockSerializationError(String e) {
                this.e = e;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                BlockSerializationError other = (BlockSerializationError)o;
                return this.e.equals(other.e);
            }

            public int hashCode() {
                return Objects.hash(this.e);
            }

            public String toString() {
                return "Error.FormatError.BlockSerializationError{ error: " + this.e + " }";
            }
        }

        public static class BlockDeserializationError
        extends FormatError {
            public final String e;

            public BlockDeserializationError(String e) {
                this.e = e;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                BlockDeserializationError other = (BlockDeserializationError)o;
                return this.e.equals(other.e);
            }

            public int hashCode() {
                return Objects.hash(this.e);
            }

            public String toString() {
                return "Error.FormatError.BlockDeserializationError{ error: " + this.e + " }";
            }
        }

        public static class SerializationError
        extends FormatError {
            public final String e;

            public SerializationError(String e) {
                this.e = e;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SerializationError other = (SerializationError)o;
                return this.e.equals(other.e);
            }

            public int hashCode() {
                return Objects.hash(this.e);
            }

            public String toString() {
                return "Error.FormatError.SerializationError{ error: " + this.e + " }";
            }
        }

        public static class DeserializationError
        extends FormatError {
            public final String e;

            public DeserializationError(String e) {
                this.e = e;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DeserializationError other = (DeserializationError)o;
                return this.e.equals(other.e);
            }

            public int hashCode() {
                return Objects.hash(this.e);
            }

            public String toString() {
                return "Error.FormatError.DeserializationError{ error: " + this.e + " }";
            }
        }

        public static class UnknownPublicKey
        extends FormatError {
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                return o != null && this.getClass() == o.getClass();
            }
        }

        public static class EmptyKeys
        extends FormatError {
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                return o != null && this.getClass() == o.getClass();
            }
        }

        public static class SealedSignature
        extends FormatError {
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                return o != null && this.getClass() == o.getClass();
            }
        }

        public static class Signature
        extends FormatError {

            public static class InvalidSignature
            extends Signature {
                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    return o != null && this.getClass() == o.getClass();
                }
            }

            public static class InvalidFormat
            extends Signature {
                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    return o != null && this.getClass() == o.getClass();
                }
            }
        }
    }

    public static class InternalError
    extends Error {
    }
}

