/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import com.clevercloud.biscuit.crypto.TokenSignature;
import com.clevercloud.biscuit.datalog.Check;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.datalog.World;
import com.clevercloud.biscuit.datalog.expressions.Expression;
import com.clevercloud.biscuit.token.builder.Utils;
import io.vavr.control.Option;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;

public final class SymbolTable
implements Serializable {
    public final List<String> symbols = new ArrayList<String>();

    public long insert(String symbol) {
        int index = this.symbols.indexOf(symbol);
        if (index == -1) {
            this.symbols.add(symbol);
            return this.symbols.size() - 1;
        }
        return index;
    }

    public ID add(String symbol) {
        return new ID.Symbol(this.insert(symbol));
    }

    public Option<Long> get(String symbol) {
        long index = this.symbols.indexOf(symbol);
        if (index == -1L) {
            return Option.none();
        }
        return Option.some((Object)index);
    }

    public String print_id(ID value) {
        String _s = "";
        if (value instanceof ID.Bool) {
            _s = Boolean.toString(((ID.Bool)value).value());
        } else if (value instanceof ID.Bytes) {
            _s = TokenSignature.hex(((ID.Bytes)value).value());
        } else if (value instanceof ID.Date) {
            Date d = Date.from(Instant.ofEpochSecond(((ID.Date)value).value()));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            _s = format.format(d).toString();
        } else if (value instanceof ID.Integer) {
            _s = Long.toString(((ID.Integer)value).value());
        } else if (value instanceof ID.Set) {
            ID.Set idset = (ID.Set)value;
            if (idset.value().size() > 0) {
                _s = "[ ";
                _s = _s + String.join((CharSequence)", ", idset.value().stream().map(id -> this.print_id((ID)id)).collect(Collectors.toList()));
                _s = _s + " ]";
            }
        } else if (value instanceof ID.Str) {
            _s = "\"" + ((ID.Str)value).value() + "\"";
        } else if (value instanceof ID.Symbol) {
            _s = "#" + this.print_symbol((int)((ID.Symbol)value).value());
        } else if (value instanceof ID.Variable) {
            _s = "$" + this.print_symbol((int)((ID.Variable)value).value());
        }
        return _s;
    }

    public String print_rule(Rule r) {
        String res = this.print_predicate(r.head());
        res = res + " <- " + this.print_rule_body(r);
        return res;
    }

    public String print_rule_body(Rule r) {
        List preds = r.body().stream().map(p -> this.print_predicate((Predicate)p)).collect(Collectors.toList());
        List expressions = r.expressions().stream().map(c -> this.print_expression((Expression)c)).collect(Collectors.toList());
        String res = String.join((CharSequence)", ", preds);
        if (!expressions.isEmpty()) {
            if (!preds.isEmpty()) {
                res = res + ", ";
            }
            res = res + String.join((CharSequence)", ", expressions);
        }
        return res;
    }

    public String print_expression(Expression e) {
        return (String)e.print(this).get();
    }

    public String print_predicate(Predicate p) {
        List ids = p.ids().stream().map(i -> {
            if (i instanceof ID.Variable) {
                return "$" + this.print_symbol((int)((ID.Variable)i).value());
            }
            if (i instanceof ID.Symbol) {
                return "#" + this.print_symbol((int)((ID.Symbol)i).value());
            }
            if (i instanceof ID.Date) {
                return Date.from(Instant.ofEpochSecond(((ID.Date)i).value())).toString();
            }
            if (i instanceof ID.Integer) {
                return "" + ((ID.Integer)i).value();
            }
            if (i instanceof ID.Str) {
                return "\"" + ((ID.Str)i).value() + "\"";
            }
            if (i instanceof ID.Bytes) {
                return "hex:" + Utils.byteArrayToHexString(((ID.Bytes)i).value());
            }
            return "???";
        }).collect(Collectors.toList());
        return Optional.ofNullable(this.print_symbol((int)p.name())).orElse("<?>") + "(" + String.join((CharSequence)", ", ids) + ")";
    }

    public String print_fact(Fact f) {
        return this.print_predicate(f.predicate());
    }

    public String print_check(Check c) {
        String res = "check if ";
        List queries = c.queries().stream().map(q -> this.print_rule_body((Rule)q)).collect(Collectors.toList());
        return res + String.join((CharSequence)" or ", queries);
    }

    public String print_world(World w) {
        List facts = w.facts().stream().map(f -> this.print_fact((Fact)f)).collect(Collectors.toList());
        List rules = w.rules().stream().map(r -> this.print_rule((Rule)r)).collect(Collectors.toList());
        List checksStr = w.checks().stream().map(c -> this.print_check((Check)c)).collect(Collectors.toList());
        StringBuilder b = new StringBuilder();
        b.append("World {\n\tfacts: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", facts));
        b.append("\n\t],\n\trules: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", rules));
        b.append("\n\t],\n\tchecks: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", checksStr));
        b.append("\n\t]\n}");
        return b.toString();
    }

    public String print_symbol(int i) {
        if (i >= 0 && i < this.symbols.size()) {
            return this.symbols.get(i);
        }
        return "<" + i + "?>";
    }

    public SymbolTable() {
    }

    public SymbolTable(SymbolTable s) {
        for (String symbol : s.symbols) {
            this.symbols.add(symbol);
        }
    }
}

