/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog.expressions;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.error.Error;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import io.vavr.API;
import io.vavr.control.Either;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;

public abstract class Op {
    public abstract boolean evaluate(Deque<ID> var1, Map<Long, ID> var2);

    public abstract String print(Deque<String> var1, SymbolTable var2);

    public abstract Schema.Op serialize();

    public static Either<Error.FormatError, Op> deserializeV1(Schema.Op op) {
        if (op.hasValue()) {
            return ID.deserialize_enumV1(op.getValue()).map(v -> new Value((ID)v));
        }
        if (op.hasUnary()) {
            return Unary.deserializeV1(op.getUnary());
        }
        if (op.hasBinary()) {
            return Binary.deserializeV1(op.getBinary());
        }
        return API.Left((Object)new Error.FormatError.DeserializationError("invalid unary operation"));
    }

    public static final class Binary
    extends Op {
        private final BinaryOp op;

        public Binary(BinaryOp value) {
            this.op = value;
        }

        public BinaryOp getOp() {
            return this.op;
        }

        @Override
        public boolean evaluate(Deque<ID> stack, Map<Long, ID> variables) {
            ID right = stack.pop();
            ID left = stack.pop();
            switch (this.op) {
                case LessThan: {
                    if (right instanceof ID.Integer && left instanceof ID.Integer) {
                        stack.push(new ID.Bool(((ID.Integer)left).value() < ((ID.Integer)right).value()));
                        return true;
                    }
                    if (!(right instanceof ID.Date) || !(left instanceof ID.Date)) break;
                    stack.push(new ID.Bool(((ID.Date)left).value() < ((ID.Date)right).value()));
                    return true;
                }
                case GreaterThan: {
                    if (right instanceof ID.Integer && left instanceof ID.Integer) {
                        stack.push(new ID.Bool(((ID.Integer)left).value() > ((ID.Integer)right).value()));
                        return true;
                    }
                    if (!(right instanceof ID.Date) || !(left instanceof ID.Date)) break;
                    stack.push(new ID.Bool(((ID.Date)left).value() > ((ID.Date)right).value()));
                    return true;
                }
                case LessOrEqual: {
                    if (right instanceof ID.Integer && left instanceof ID.Integer) {
                        stack.push(new ID.Bool(((ID.Integer)left).value() <= ((ID.Integer)right).value()));
                        return true;
                    }
                    if (!(right instanceof ID.Date) || !(left instanceof ID.Date)) break;
                    stack.push(new ID.Bool(((ID.Date)left).value() <= ((ID.Date)right).value()));
                    return true;
                }
                case GreaterOrEqual: {
                    if (right instanceof ID.Integer && left instanceof ID.Integer) {
                        stack.push(new ID.Bool(((ID.Integer)left).value() >= ((ID.Integer)right).value()));
                        return true;
                    }
                    if (!(right instanceof ID.Date) || !(left instanceof ID.Date)) break;
                    stack.push(new ID.Bool(((ID.Date)left).value() >= ((ID.Date)right).value()));
                    return true;
                }
                case Equal: {
                    if (right instanceof ID.Integer && left instanceof ID.Integer) {
                        stack.push(new ID.Bool(((ID.Integer)left).value() == ((ID.Integer)right).value()));
                        return true;
                    }
                    if (right instanceof ID.Str && left instanceof ID.Str) {
                        stack.push(new ID.Bool(((ID.Str)left).value().equals(((ID.Str)right).value())));
                        return true;
                    }
                    if (right instanceof ID.Bytes && left instanceof ID.Bytes) {
                        stack.push(new ID.Bool(Arrays.equals(((ID.Bytes)left).value(), ((ID.Bytes)right).value())));
                        return true;
                    }
                    if (right instanceof ID.Date && left instanceof ID.Date) {
                        stack.push(new ID.Bool(((ID.Date)left).value() == ((ID.Date)right).value()));
                        return true;
                    }
                    if (right instanceof ID.Symbol && left instanceof ID.Symbol) {
                        stack.push(new ID.Bool(((ID.Symbol)left).value() == ((ID.Symbol)right).value()));
                        return true;
                    }
                    if (!(right instanceof ID.Set) || !(left instanceof ID.Set)) break;
                    HashSet<ID> leftSet = ((ID.Set)left).value();
                    HashSet<ID> rightSet = ((ID.Set)right).value();
                    stack.push(new ID.Bool(leftSet.size() == rightSet.size() && leftSet.containsAll(rightSet)));
                    return true;
                }
                case Contains: {
                    if (left instanceof ID.Set && (right instanceof ID.Integer || right instanceof ID.Str || right instanceof ID.Bytes || right instanceof ID.Date || right instanceof ID.Bool || right instanceof ID.Symbol)) {
                        stack.push(new ID.Bool(((ID.Set)left).value().contains(right)));
                        return true;
                    }
                    if (!(right instanceof ID.Set) || !(left instanceof ID.Set)) break;
                    HashSet<ID> leftSet = ((ID.Set)left).value();
                    HashSet<ID> rightSet = ((ID.Set)right).value();
                    stack.push(new ID.Bool(leftSet.containsAll(rightSet)));
                    return true;
                }
                case Prefix: {
                    if (!(right instanceof ID.Str) || !(left instanceof ID.Str)) break;
                    stack.push(new ID.Bool(((ID.Str)left).value().startsWith(((ID.Str)right).value())));
                    return true;
                }
                case Suffix: {
                    if (!(right instanceof ID.Str) || !(left instanceof ID.Str)) break;
                    stack.push(new ID.Bool(((ID.Str)left).value().endsWith(((ID.Str)right).value())));
                    return true;
                }
                case Regex: {
                    if (!(right instanceof ID.Str) || !(left instanceof ID.Str)) break;
                    Pattern p = Pattern.compile((String)((ID.Str)right).value());
                    Matcher m = p.matcher((CharSequence)((ID.Str)left).value());
                    stack.push(new ID.Bool(m.find()));
                    return true;
                }
                case Add: {
                    if (!(right instanceof ID.Integer) || !(left instanceof ID.Integer)) break;
                    stack.push(new ID.Integer(((ID.Integer)left).value() + ((ID.Integer)right).value()));
                    return true;
                }
                case Sub: {
                    if (!(right instanceof ID.Integer) || !(left instanceof ID.Integer)) break;
                    stack.push(new ID.Integer(((ID.Integer)left).value() - ((ID.Integer)right).value()));
                    return true;
                }
                case Mul: {
                    if (!(right instanceof ID.Integer) || !(left instanceof ID.Integer)) break;
                    stack.push(new ID.Integer(((ID.Integer)left).value() * ((ID.Integer)right).value()));
                    return true;
                }
                case Div: {
                    long rl;
                    if (!(right instanceof ID.Integer) || !(left instanceof ID.Integer) || (rl = ((ID.Integer)right).value()) == 0L) break;
                    stack.push(new ID.Integer(((ID.Integer)left).value() / rl));
                    return true;
                }
                case And: {
                    if (!(right instanceof ID.Bool) || !(left instanceof ID.Bool)) break;
                    stack.push(new ID.Bool(((ID.Bool)left).value() && ((ID.Bool)right).value()));
                    return true;
                }
                case Or: {
                    if (!(right instanceof ID.Bool) || !(left instanceof ID.Bool)) break;
                    stack.push(new ID.Bool(((ID.Bool)left).value() || ((ID.Bool)right).value()));
                    return true;
                }
                case Intersection: {
                    if (!(right instanceof ID.Set) || !(left instanceof ID.Set)) break;
                    HashSet<ID> intersec = new HashSet<ID>();
                    HashSet<ID> _right = ((ID.Set)right).value();
                    HashSet<ID> _left = ((ID.Set)left).value();
                    for (ID _id : _right) {
                        if (!_left.contains(_id)) continue;
                        intersec.add(_id);
                    }
                    stack.push(new ID.Set(intersec));
                    return true;
                }
                case Union: {
                    if (!(right instanceof ID.Set) || !(left instanceof ID.Set)) break;
                    HashSet<ID> union = new HashSet<ID>();
                    HashSet<ID> _right = ((ID.Set)right).value();
                    HashSet<ID> _left = ((ID.Set)left).value();
                    union.addAll(_right);
                    union.addAll(_left);
                    stack.push(new ID.Set(union));
                    return true;
                }
                default: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public String print(Deque<String> stack, SymbolTable symbols) {
            String right = stack.pop();
            String left = stack.pop();
            String _s = "";
            switch (this.op) {
                case LessThan: {
                    _s = left + " < " + right;
                    stack.push(_s);
                    break;
                }
                case GreaterThan: {
                    _s = left + " > " + right;
                    stack.push(_s);
                    break;
                }
                case LessOrEqual: {
                    _s = left + " <= " + right;
                    stack.push(_s);
                    break;
                }
                case GreaterOrEqual: {
                    _s = left + " >= " + right;
                    stack.push(_s);
                    break;
                }
                case Equal: {
                    _s = left + " == " + right;
                    stack.push(_s);
                    break;
                }
                case Contains: {
                    _s = left + ".contains(" + right + ")";
                    stack.push(_s);
                    break;
                }
                case Prefix: {
                    _s = left + ".starts_with(" + right + ")";
                    stack.push(_s);
                    break;
                }
                case Suffix: {
                    _s = left + ".ends_with(" + right + ")";
                    stack.push(_s);
                    break;
                }
                case Regex: {
                    _s = left + ".matches(" + right + ")";
                    stack.push(_s);
                    break;
                }
                case Add: {
                    _s = left + " + " + right;
                    stack.push(_s);
                    break;
                }
                case Sub: {
                    _s = left + " - " + right;
                    stack.push(_s);
                    break;
                }
                case Mul: {
                    _s = left + " * " + right;
                    stack.push(_s);
                    break;
                }
                case Div: {
                    _s = left + " / " + right;
                    stack.push(_s);
                    break;
                }
                case And: {
                    _s = left + " && " + right;
                    stack.push(_s);
                    break;
                }
                case Or: {
                    _s = left + " || " + right;
                    stack.push(_s);
                    break;
                }
                case Intersection: {
                    _s = left + ".intersection(" + right + ")";
                    stack.push(_s);
                    break;
                }
                case Union: {
                    _s = left + ".union(" + right + ")";
                    stack.push(_s);
                }
            }
            return _s;
        }

        @Override
        public Schema.Op serialize() {
            Schema.Op.Builder b = Schema.Op.newBuilder();
            Schema.OpBinary.Builder b1 = Schema.OpBinary.newBuilder();
            switch (this.op) {
                case LessThan: {
                    b1.setKind(Schema.OpBinary.Kind.LessThan);
                    break;
                }
                case GreaterThan: {
                    b1.setKind(Schema.OpBinary.Kind.GreaterThan);
                    break;
                }
                case LessOrEqual: {
                    b1.setKind(Schema.OpBinary.Kind.LessOrEqual);
                    break;
                }
                case GreaterOrEqual: {
                    b1.setKind(Schema.OpBinary.Kind.GreaterOrEqual);
                    break;
                }
                case Equal: {
                    b1.setKind(Schema.OpBinary.Kind.Equal);
                    break;
                }
                case Contains: {
                    b1.setKind(Schema.OpBinary.Kind.Contains);
                    break;
                }
                case Prefix: {
                    b1.setKind(Schema.OpBinary.Kind.Prefix);
                    break;
                }
                case Suffix: {
                    b1.setKind(Schema.OpBinary.Kind.Suffix);
                    break;
                }
                case Regex: {
                    b1.setKind(Schema.OpBinary.Kind.Regex);
                    break;
                }
                case Add: {
                    b1.setKind(Schema.OpBinary.Kind.Add);
                    break;
                }
                case Sub: {
                    b1.setKind(Schema.OpBinary.Kind.Sub);
                    break;
                }
                case Mul: {
                    b1.setKind(Schema.OpBinary.Kind.Mul);
                    break;
                }
                case Div: {
                    b1.setKind(Schema.OpBinary.Kind.Div);
                    break;
                }
                case And: {
                    b1.setKind(Schema.OpBinary.Kind.And);
                    break;
                }
                case Or: {
                    b1.setKind(Schema.OpBinary.Kind.Or);
                    break;
                }
                case Intersection: {
                    b1.setKind(Schema.OpBinary.Kind.Intersection);
                    break;
                }
                case Union: {
                    b1.setKind(Schema.OpBinary.Kind.Union);
                }
            }
            b.setBinary(b1.build());
            return b.build();
        }

        public static Either<Error.FormatError, Op> deserializeV1(Schema.OpBinary op) {
            switch (op.getKind()) {
                case LessThan: {
                    return API.Right((Object)new Binary(BinaryOp.LessThan));
                }
                case GreaterThan: {
                    return API.Right((Object)new Binary(BinaryOp.GreaterThan));
                }
                case LessOrEqual: {
                    return API.Right((Object)new Binary(BinaryOp.LessOrEqual));
                }
                case GreaterOrEqual: {
                    return API.Right((Object)new Binary(BinaryOp.GreaterOrEqual));
                }
                case Equal: {
                    return API.Right((Object)new Binary(BinaryOp.Equal));
                }
                case Contains: {
                    return API.Right((Object)new Binary(BinaryOp.Contains));
                }
                case Prefix: {
                    return API.Right((Object)new Binary(BinaryOp.Prefix));
                }
                case Suffix: {
                    return API.Right((Object)new Binary(BinaryOp.Suffix));
                }
                case Regex: {
                    return API.Right((Object)new Binary(BinaryOp.Regex));
                }
                case Add: {
                    return API.Right((Object)new Binary(BinaryOp.Add));
                }
                case Sub: {
                    return API.Right((Object)new Binary(BinaryOp.Sub));
                }
                case Mul: {
                    return API.Right((Object)new Binary(BinaryOp.Mul));
                }
                case Div: {
                    return API.Right((Object)new Binary(BinaryOp.Div));
                }
                case And: {
                    return API.Right((Object)new Binary(BinaryOp.And));
                }
                case Or: {
                    return API.Right((Object)new Binary(BinaryOp.Or));
                }
                case Intersection: {
                    return API.Right((Object)new Binary(BinaryOp.Intersection));
                }
                case Union: {
                    return API.Right((Object)new Binary(BinaryOp.Union));
                }
            }
            return API.Left((Object)new Error.FormatError.DeserializationError("invalid binary operation"));
        }

        public String toString() {
            return "Binary." + (Object)((Object)this.op);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Binary binary = (Binary)o;
            return this.op == binary.op;
        }

        public int hashCode() {
            return this.op.hashCode();
        }
    }

    public static enum BinaryOp {
        LessThan,
        GreaterThan,
        LessOrEqual,
        GreaterOrEqual,
        Equal,
        Contains,
        Prefix,
        Suffix,
        Regex,
        Add,
        Sub,
        Mul,
        Div,
        And,
        Or,
        Intersection,
        Union;

    }

    public static final class Unary
    extends Op {
        private final UnaryOp op;

        public Unary(UnaryOp op) {
            this.op = op;
        }

        public UnaryOp getOp() {
            return this.op;
        }

        @Override
        public boolean evaluate(Deque<ID> stack, Map<Long, ID> variables) {
            ID value = stack.pop();
            switch (this.op) {
                case Negate: {
                    if (value instanceof ID.Bool) {
                        ID.Bool b = (ID.Bool)value;
                        stack.push(new ID.Bool(!b.value()));
                        break;
                    }
                    return false;
                }
                case Parens: {
                    stack.push(value);
                    break;
                }
                case Length: {
                    if (value instanceof ID.Str) {
                        stack.push(new ID.Integer(((ID.Str)value).value().length()));
                        break;
                    }
                    if (value instanceof ID.Bytes) {
                        stack.push(new ID.Integer(((ID.Bytes)value).value().length));
                        break;
                    }
                    if (value instanceof ID.Set) {
                        stack.push(new ID.Integer(((ID.Set)value).value().size()));
                        break;
                    }
                    return false;
                }
            }
            return true;
        }

        @Override
        public String print(Deque<String> stack, SymbolTable symbols) {
            String prec = stack.pop();
            String _s = "";
            switch (this.op) {
                case Negate: {
                    _s = "! " + prec;
                    stack.push(_s);
                    break;
                }
                case Parens: {
                    _s = "(" + prec + ")";
                    stack.push(_s);
                }
            }
            return _s;
        }

        @Override
        public Schema.Op serialize() {
            Schema.Op.Builder b = Schema.Op.newBuilder();
            Schema.OpUnary.Builder b1 = Schema.OpUnary.newBuilder();
            switch (this.op) {
                case Negate: {
                    b1.setKind(Schema.OpUnary.Kind.Negate);
                    break;
                }
                case Parens: {
                    b1.setKind(Schema.OpUnary.Kind.Parens);
                    break;
                }
                case Length: {
                    b1.setKind(Schema.OpUnary.Kind.Length);
                }
            }
            b.setUnary(b1.build());
            return b.build();
        }

        public static Either<Error.FormatError, Op> deserializeV1(Schema.OpUnary op) {
            switch (op.getKind()) {
                case Negate: {
                    return API.Right((Object)new Unary(UnaryOp.Negate));
                }
                case Parens: {
                    return API.Right((Object)new Unary(UnaryOp.Parens));
                }
                case Length: {
                    return API.Right((Object)new Unary(UnaryOp.Length));
                }
            }
            return API.Left((Object)new Error.FormatError.DeserializationError("invalid unary operation"));
        }

        public String toString() {
            return "Unary." + (Object)((Object)this.op);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unary unary = (Unary)o;
            return this.op == unary.op;
        }

        public int hashCode() {
            return this.op.hashCode();
        }
    }

    public static enum UnaryOp {
        Negate,
        Parens,
        Length;

    }

    public static final class Value
    extends Op {
        private final ID value;

        public Value(ID value) {
            this.value = value;
        }

        public ID getValue() {
            return this.value;
        }

        @Override
        public boolean evaluate(Deque<ID> stack, Map<Long, ID> variables) {
            if (this.value instanceof ID.Variable) {
                ID.Variable var = (ID.Variable)this.value;
                ID valueVar = variables.get(var.value());
                if (valueVar != null) {
                    stack.push(valueVar);
                    return true;
                }
                return false;
            }
            stack.push(this.value);
            return true;
        }

        @Override
        public String print(Deque<String> stack, SymbolTable symbols) {
            String s = symbols.print_id(this.value);
            stack.push(s);
            return s;
        }

        @Override
        public Schema.Op serialize() {
            Schema.Op.Builder b = Schema.Op.newBuilder();
            b.setValue(this.value.serialize());
            return b.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value1 = (Value)o;
            return this.value.equals(value1.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "Value(" + this.value + ')';
        }
    }
}

