/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.token.builder.Check;
import com.clevercloud.biscuit.token.builder.Expression;
import com.clevercloud.biscuit.token.builder.Fact;
import com.clevercloud.biscuit.token.builder.Rule;
import com.clevercloud.biscuit.token.builder.Utils;
import com.clevercloud.biscuit.token.builder.parser.Error;
import com.clevercloud.biscuit.token.builder.parser.Parser;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class Block {
    long index;
    int symbol_start;
    SymbolTable symbols;
    String context;
    List<com.clevercloud.biscuit.datalog.Fact> facts;
    List<com.clevercloud.biscuit.datalog.Rule> rules;
    List<com.clevercloud.biscuit.datalog.Check> checks;

    public Block(long index, SymbolTable base_symbols) {
        this.index = index;
        this.symbol_start = base_symbols.symbols.size();
        this.symbols = new SymbolTable(base_symbols);
        this.context = "";
        this.facts = new ArrayList<com.clevercloud.biscuit.datalog.Fact>();
        this.rules = new ArrayList<com.clevercloud.biscuit.datalog.Rule>();
        this.checks = new ArrayList<com.clevercloud.biscuit.datalog.Check>();
    }

    public void add_fact(Fact f) {
        this.facts.add(f.convert(this.symbols));
    }

    public Either<com.clevercloud.biscuit.error.Error, Void> add_fact(String s) {
        Either<Error, Tuple2<String, Fact>> res = Parser.fact(s);
        if (res.isLeft()) {
            return Either.left((Object)new Error.Parser((Error)res.getLeft()));
        }
        Tuple2 t = (Tuple2)res.get();
        this.add_fact((Fact)t._2);
        return Either.right(null);
    }

    public void add_rule(Rule rule) {
        this.rules.add(rule.convert(this.symbols));
    }

    public Either<com.clevercloud.biscuit.error.Error, Void> add_rule(String s) {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            return Either.left((Object)new Error.Parser((Error)res.getLeft()));
        }
        Tuple2 t = (Tuple2)res.get();
        this.add_rule((Rule)t._2);
        return Either.right(null);
    }

    public void add_check(Check check) {
        this.checks.add(check.convert(this.symbols));
    }

    public Either<com.clevercloud.biscuit.error.Error, Void> add_check(String s) {
        Either<Error, Tuple2<String, Check>> res = Parser.check(s);
        if (res.isLeft()) {
            return Either.left((Object)new Error.Parser((Error)res.getLeft()));
        }
        Tuple2 t = (Tuple2)res.get();
        this.add_check((Check)t._2);
        return Either.right(null);
    }

    public void set_context(String context) {
        this.context = context;
    }

    public com.clevercloud.biscuit.token.Block build() {
        SymbolTable symbols = new SymbolTable();
        for (int i = this.symbol_start; i < this.symbols.symbols.size(); ++i) {
            symbols.add(this.symbols.symbols.get(i));
        }
        return new com.clevercloud.biscuit.token.Block(this.index, symbols, this.context, this.facts, this.rules, this.checks);
    }

    public void check_right(String right) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.rule("check_right", Arrays.asList(Utils.s(right)), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.s("ambient"), Utils.var("resource"))), Utils.pred("operation", Arrays.asList(Utils.s("ambient"), Utils.s(right))), Utils.pred("right", Arrays.asList(Utils.s("authority"), Utils.var("resource"), Utils.s(right))))));
        this.add_check(new Check(queries));
    }

    public void resource_prefix(String prefix) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("prefix", Arrays.asList(Utils.var("resource")), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.s("ambient"), Utils.var("resource")))), Arrays.asList(new Expression.Binary(Expression.Op.Prefix, new Expression.Value(Utils.var("resource")), new Expression.Value(Utils.string(prefix))))));
        this.add_check(new Check(queries));
    }

    public void resource_suffix(String suffix) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("suffix", Arrays.asList(Utils.var("resource")), Arrays.asList(Utils.pred("resource", Arrays.asList(Utils.s("ambient"), Utils.var("resource")))), Arrays.asList(new Expression.Binary(Expression.Op.Suffix, new Expression.Value(Utils.var("resource")), new Expression.Value(Utils.string(suffix))))));
        this.add_check(new Check(queries));
    }

    public void expiration_date(Date d) {
        ArrayList<Rule> queries = new ArrayList<Rule>();
        queries.add(Utils.constrained_rule("expiration", Arrays.asList(Utils.var("date")), Arrays.asList(Utils.pred("time", Arrays.asList(Utils.s("ambient"), Utils.var("date")))), Arrays.asList(new Expression.Binary(Expression.Op.LessOrEqual, new Expression.Value(Utils.var("date")), new Expression.Value(Utils.date(d))))));
        this.add_check(new Check(queries));
    }
}

