/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token;

import com.clevercloud.biscuit.crypto.PublicKey;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.RunLimits;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.World;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.error.FailedCheck;
import com.clevercloud.biscuit.error.LogicError;
import com.clevercloud.biscuit.token.Biscuit;
import com.clevercloud.biscuit.token.Block;
import com.clevercloud.biscuit.token.Policy;
import com.clevercloud.biscuit.token.RevocationIdentifier;
import com.clevercloud.biscuit.token.builder.Check;
import com.clevercloud.biscuit.token.builder.Expression;
import com.clevercloud.biscuit.token.builder.Fact;
import com.clevercloud.biscuit.token.builder.Predicate;
import com.clevercloud.biscuit.token.builder.Rule;
import com.clevercloud.biscuit.token.builder.Term;
import com.clevercloud.biscuit.token.builder.Utils;
import com.clevercloud.biscuit.token.builder.parser.Error;
import com.clevercloud.biscuit.token.builder.parser.Parser;
import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Verifier {
    Biscuit token;
    List<Check> checks;
    List<List<com.clevercloud.biscuit.datalog.Check>> token_checks;
    List<Policy> policies;
    World world;
    SymbolTable symbols;

    private Verifier(Biscuit token, World w) {
        this.token = token;
        this.world = w;
        this.symbols = new SymbolTable(this.token.symbols);
        this.checks = new ArrayList<Check>();
        this.policies = new ArrayList<Policy>();
        this.token_checks = this.token.checks();
    }

    public Verifier() {
        this.world = new World();
        this.symbols = Biscuit.default_symbol_table();
        this.checks = new ArrayList<Check>();
        this.policies = new ArrayList<Policy>();
        this.token_checks = new ArrayList<List<com.clevercloud.biscuit.datalog.Check>>();
    }

    Verifier(Biscuit token, List<Check> checks, List<Policy> policies, List<List<com.clevercloud.biscuit.datalog.Check>> token_checks, World world, SymbolTable symbols) {
        this.token = token;
        this.checks = checks;
        this.policies = policies;
        this.token_checks = token_checks;
        this.world = world;
        this.symbols = symbols;
    }

    public static Either<com.clevercloud.biscuit.error.Error, Verifier> make(Biscuit token, Option<PublicKey> root) {
        Object res;
        if (!token.is_sealed() && (res = token.check_root_key((PublicKey)root.get())).isLeft()) {
            com.clevercloud.biscuit.error.Error e = (com.clevercloud.biscuit.error.Error)res.getLeft();
            return API.Left((Object)e);
        }
        res = token.generate_world();
        if (res.isLeft()) {
            com.clevercloud.biscuit.error.Error e = (com.clevercloud.biscuit.error.Error)res.getLeft();
            return API.Left((Object)e);
        }
        return API.Right((Object)new Verifier(token, (World)res.get()));
    }

    public Verifier clone() {
        return new Verifier(this.token, new ArrayList<Check>(this.checks), new ArrayList<Policy>(this.policies), new ArrayList<List<com.clevercloud.biscuit.datalog.Check>>(this.token_checks), new World(this.world), new SymbolTable(this.symbols));
    }

    /*
     * WARNING - void declaration
     */
    public Either<com.clevercloud.biscuit.error.Error, Void> add_token(Biscuit token, Option<PublicKey> root) {
        void var11_24;
        void var8_13;
        Either<com.clevercloud.biscuit.error.Error, Void> res;
        if (!token.is_sealed() && (res = token.check_root_key((PublicKey)root.get())).isLeft()) {
            com.clevercloud.biscuit.error.Error e = (com.clevercloud.biscuit.error.Error)res.getLeft();
            return API.Left((Object)e);
        }
        if (this.token != null) {
            return Either.left((Object)new Error.FailedLogic(new LogicError.VerifierNotEmpty()));
        }
        long authority_index = (Long)this.symbols.get("authority").get();
        long ambient_index = (Long)this.symbols.get("ambient").get();
        for (com.clevercloud.biscuit.datalog.Fact fact : token.authority.facts) {
            if (fact.predicate().ids().get(0).equals(new ID.Symbol(ambient_index))) {
                return API.Left((Object)new Error.FailedLogic(new LogicError.InvalidAuthorityFact(this.symbols.print_fact(fact))));
            }
            com.clevercloud.biscuit.datalog.Fact converted_fact = Fact.convert_from(fact, token.symbols).convert(this.symbols);
            this.world.add_fact(converted_fact);
        }
        for (com.clevercloud.biscuit.datalog.Rule rule : token.authority.rules) {
            com.clevercloud.biscuit.datalog.Rule converted_rule = Rule.convert_from(rule, token.symbols).convert(this.symbols);
            this.world.add_privileged_rule(converted_rule);
        }
        ArrayList<com.clevercloud.biscuit.datalog.Check> authority_checks = new ArrayList<com.clevercloud.biscuit.datalog.Check>();
        for (com.clevercloud.biscuit.datalog.Check check : token.authority.checks) {
            Iterator<com.clevercloud.biscuit.datalog.Rule> converted_check = Check.convert_from(check, token.symbols).convert(this.symbols);
            authority_checks.add((com.clevercloud.biscuit.datalog.Check)((Object)converted_check));
        }
        this.token_checks.add(authority_checks);
        boolean bl = false;
        while (var8_13 < token.blocks.size()) {
            Block b = token.blocks.get((int)var8_13);
            if (b.index != (long)(var8_13 + true)) {
                return API.Left((Object)new Error.InvalidBlockIndex(1 + token.blocks.size(), token.blocks.get((int)var8_13).index));
            }
            for (com.clevercloud.biscuit.datalog.Fact fact : b.facts) {
                if (fact.predicate().ids().get(0).equals(new ID.Symbol(authority_index)) || fact.predicate().ids().get(0).equals(new ID.Symbol(ambient_index))) {
                    return API.Left((Object)new Error.FailedLogic(new LogicError.InvalidBlockFact((long)var8_13, this.symbols.print_fact(fact))));
                }
                com.clevercloud.biscuit.datalog.Fact converted_fact = Fact.convert_from(fact, token.symbols).convert(this.symbols);
                this.world.add_fact(converted_fact);
            }
            for (com.clevercloud.biscuit.datalog.Rule rule : b.rules) {
                com.clevercloud.biscuit.datalog.Rule converted_rule = Rule.convert_from(rule, token.symbols).convert(this.symbols);
                this.world.add_rule(converted_rule);
            }
            ArrayList<com.clevercloud.biscuit.datalog.Check> block_checks = new ArrayList<com.clevercloud.biscuit.datalog.Check>();
            for (com.clevercloud.biscuit.datalog.Check check : b.checks) {
                com.clevercloud.biscuit.datalog.Check converted_check = Check.convert_from(check, token.symbols).convert(this.symbols);
                block_checks.add(converted_check);
            }
            this.token_checks.add(block_checks);
            ++var8_13;
        }
        List<RevocationIdentifier> list = token.revocation_identifiers();
        long rev = (Long)this.symbols.get("revocation_id").get();
        boolean bl2 = false;
        while (var11_24 < list.size()) {
            byte[] id = list.get((int)var11_24).getBytes();
            this.world.add_fact(new com.clevercloud.biscuit.datalog.Fact(new com.clevercloud.biscuit.datalog.Predicate(rev, Arrays.asList(new ID.Integer((long)var11_24), new ID.Bytes(id)))));
            ++var11_24;
        }
        return API.Right(null);
    }

    public void add_fact(Fact fact) {
        this.world.add_fact(fact.convert(this.symbols));
    }

    public Either<com.clevercloud.biscuit.error.Error, Void> add_fact(String s) {
        Either<Error, Tuple2<String, Fact>> res = Parser.fact(s);
        if (res.isLeft()) {
            return Either.left((Object)new Error.Parser((Error)res.getLeft()));
        }
        Tuple2 t = (Tuple2)res.get();
        this.add_fact((Fact)t._2);
        return Either.right(null);
    }

    public void add_rule(Rule rule) {
        this.world.add_privileged_rule(rule.convert(this.symbols));
    }

    public Either<com.clevercloud.biscuit.error.Error, Void> add_rule(String s) {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            return Either.left((Object)new Error.Parser((Error)res.getLeft()));
        }
        Tuple2 t = (Tuple2)res.get();
        this.add_rule((Rule)t._2);
        return Either.right(null);
    }

    public void add_check(Check check) {
        this.checks.add(check);
        this.world.add_check(check.convert(this.symbols));
    }

    public Either<com.clevercloud.biscuit.error.Error, Void> add_check(String s) {
        Either<Error, Tuple2<String, Check>> res = Parser.check(s);
        if (res.isLeft()) {
            return Either.left((Object)new Error.Parser((Error)res.getLeft()));
        }
        Tuple2 t = (Tuple2)res.get();
        this.add_check((Check)t._2);
        return Either.right(null);
    }

    public void add_resource(String resource) {
        this.world.add_fact(Utils.fact("resource", Arrays.asList(Utils.s("ambient"), Utils.string(resource))).convert(this.symbols));
    }

    public void add_operation(String operation) {
        this.world.add_fact(Utils.fact("operation", Arrays.asList(Utils.s("ambient"), Utils.s(operation))).convert(this.symbols));
    }

    public void set_time() {
        this.world.add_fact(Utils.fact("time", Arrays.asList(Utils.s("ambient"), Utils.date(new Date()))).convert(this.symbols));
    }

    public void revocation_check(List<Long> ids) {
        ArrayList<Rule> q = new ArrayList<Rule>();
        q.add(Utils.constrained_rule("revocation_check", Arrays.asList(Utils.var("id")), Arrays.asList(Utils.pred("revocation_id", Arrays.asList(Utils.var("id")))), Arrays.asList(new Expression.Unary(Expression.Op.Negate, new Expression.Binary(Expression.Op.Contains, new Expression.Value(Utils.var("id")), new Expression.Value(new Term.Set(new HashSet<Long>(ids))))))));
        this.checks.add(new Check(q));
    }

    public Either<com.clevercloud.biscuit.error.Error, List<String>> get_revocation_ids() {
        ArrayList ids = new ArrayList();
        Rule getRevocationIds = Utils.rule("revocation_id", Arrays.asList(Utils.var("id")), Arrays.asList(Utils.pred("revocation_id", Arrays.asList(Utils.var("id")))));
        Either<com.clevercloud.biscuit.error.Error, Set<Fact>> queryRes = this.query(getRevocationIds);
        if (queryRes.isLeft()) {
            com.clevercloud.biscuit.error.Error e = (com.clevercloud.biscuit.error.Error)queryRes.getLeft();
            return API.Left((Object)e);
        }
        ((Set)queryRes.get()).stream().forEach(fact -> fact.ids().stream().forEach(id -> {
            if (id instanceof Term.Str) {
                ids.add(((Term.Str)id).value());
            }
        }));
        return API.Right(ids);
    }

    public void allow() {
        ArrayList<Rule> q = new ArrayList<Rule>();
        q.add(Utils.constrained_rule("allow", new ArrayList<Term>(), new ArrayList<Predicate>(), Arrays.asList(new Expression.Value(new Term.Bool(true)))));
        this.policies.add(new Policy(q, Policy.Kind.Allow));
    }

    public void deny() {
        ArrayList<Rule> q = new ArrayList<Rule>();
        q.add(Utils.constrained_rule("deny", new ArrayList<Term>(), new ArrayList<Predicate>(), Arrays.asList(new Expression.Value(new Term.Bool(true)))));
        this.policies.add(new Policy(q, Policy.Kind.Deny));
    }

    public Either<com.clevercloud.biscuit.error.Error, Void> add_policy(String s) {
        Either<Error, Tuple2<String, Policy>> res = Parser.policy(s);
        if (res.isLeft()) {
            return Either.left((Object)new Error.Parser((Error)res.getLeft()));
        }
        Tuple2 t = (Tuple2)res.get();
        this.policies.add((Policy)t._2);
        return Either.right(null);
    }

    public Either<com.clevercloud.biscuit.error.Error, Set<Fact>> query(Rule query) {
        return this.query(query, new RunLimits());
    }

    public Either<com.clevercloud.biscuit.error.Error, Set<Fact>> query(String s) {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            return Either.left((Object)new Error.Parser((Error)res.getLeft()));
        }
        Tuple2 t = (Tuple2)res.get();
        return this.query((Rule)t._2);
    }

    public Either<com.clevercloud.biscuit.error.Error, Set<Fact>> query(Rule query, RunLimits limits) {
        Either<com.clevercloud.biscuit.error.Error, Void> runRes = this.world.run(limits, new HashSet<Long>());
        if (runRes.isLeft()) {
            com.clevercloud.biscuit.error.Error e = (com.clevercloud.biscuit.error.Error)runRes.getLeft();
            return API.Left((Object)e);
        }
        Set<com.clevercloud.biscuit.datalog.Fact> facts = this.world.query_rule(query.convert(this.symbols));
        HashSet<Fact> s = new HashSet<Fact>();
        for (com.clevercloud.biscuit.datalog.Fact f : facts) {
            s.add(Fact.convert_from(f, this.symbols));
        }
        return API.Right(s);
    }

    public Either<com.clevercloud.biscuit.error.Error, Set<Fact>> query(String s, RunLimits limits) {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            return Either.left((Object)new Error.Parser((Error)res.getLeft()));
        }
        Tuple2 t = (Tuple2)res.get();
        return this.query((Rule)t._2, limits);
    }

    public Either<com.clevercloud.biscuit.error.Error, Long> verify() {
        return this.verify(new RunLimits());
    }

    public Either<com.clevercloud.biscuit.error.Error, Long> verify(RunLimits limits) {
        int i;
        boolean res;
        int k;
        boolean successful;
        com.clevercloud.biscuit.datalog.Check c;
        Instant timeLimit = Instant.now().plus(limits.maxTime);
        if (this.symbols.get("authority").isEmpty() || this.symbols.get("ambient").isEmpty()) {
            return API.Left((Object)new Error.MissingSymbols());
        }
        HashSet<Long> restricted_symbols = new HashSet<Long>();
        restricted_symbols.add((Long)this.symbols.get("authority").get());
        restricted_symbols.add((Long)this.symbols.get("ambient").get());
        Either<com.clevercloud.biscuit.error.Error, Void> runRes = this.world.run(limits, restricted_symbols);
        if (runRes.isLeft()) {
            com.clevercloud.biscuit.error.Error e = (com.clevercloud.biscuit.error.Error)runRes.getLeft();
            return API.Left((Object)e);
        }
        SymbolTable symbols = new SymbolTable(this.symbols);
        ArrayList<FailedCheck> errors = new ArrayList<FailedCheck>();
        for (int j = 0; j < this.checks.size(); ++j) {
            c = this.checks.get(j).convert(symbols);
            successful = false;
            for (k = 0; k < c.queries().size(); ++k) {
                res = this.world.test_rule(c.queries().get(k));
                if (Instant.now().compareTo(timeLimit) >= 0) {
                    return API.Left((Object)new Error.Timeout());
                }
                if (!res) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            errors.add(new FailedCheck.FailedVerifier(j, symbols.print_check(c)));
        }
        for (i = 0; i < this.token_checks.size(); ++i) {
            List<com.clevercloud.biscuit.datalog.Check> checks = this.token_checks.get(i);
            for (int j = 0; j < checks.size(); ++j) {
                boolean successful2 = false;
                com.clevercloud.biscuit.datalog.Check c2 = checks.get(j);
                for (int k2 = 0; k2 < c2.queries().size(); ++k2) {
                    boolean res2 = this.world.test_rule(c2.queries().get(k2));
                    if (Instant.now().compareTo(timeLimit) >= 0) {
                        return API.Left((Object)new Error.Timeout());
                    }
                    if (!res2) continue;
                    successful2 = true;
                    break;
                }
                if (successful2) continue;
                errors.add(new FailedCheck.FailedBlock(i, j, symbols.print_check(checks.get(j))));
            }
        }
        if (errors.isEmpty()) {
            for (i = 0; i < this.policies.size(); ++i) {
                c = this.policies.get(i).convert(symbols);
                successful = false;
                for (k = 0; k < c.queries().size(); ++k) {
                    res = this.world.test_rule(c.queries().get(k));
                    if (Instant.now().compareTo(timeLimit) >= 0) {
                        return API.Left((Object)new Error.Timeout());
                    }
                    if (!res) continue;
                    if (this.policies.get((int)i).kind == Policy.Kind.Deny) {
                        return API.Left((Object)new Error.FailedLogic(new LogicError.Denied(i)));
                    }
                    return API.Right((Object)i);
                }
            }
            return API.Left((Object)new Error.FailedLogic(new LogicError.NoMatchingPolicy()));
        }
        return API.Left((Object)new Error.FailedLogic(new LogicError.FailedChecks(errors)));
    }

    public String print_world() {
        int j;
        List facts = this.world.facts().stream().map(f -> this.symbols.print_fact((com.clevercloud.biscuit.datalog.Fact)f)).collect(Collectors.toList());
        List rules = this.world.rules().stream().map(r -> this.symbols.print_rule((com.clevercloud.biscuit.datalog.Rule)r)).collect(Collectors.toList());
        List privileged_rules = this.world.privileged_rules().stream().map(r -> this.symbols.print_rule((com.clevercloud.biscuit.datalog.Rule)r)).collect(Collectors.toList());
        ArrayList<CallSite> checks = new ArrayList<CallSite>();
        for (j = 0; j < this.checks.size(); ++j) {
            checks.add((CallSite)((Object)("Verifier[" + j + "]: " + this.checks.get(j).toString())));
        }
        if (this.token != null) {
            for (j = 0; j < this.token.authority.checks.size(); ++j) {
                checks.add((CallSite)((Object)("Block[0][" + j + "]: " + this.symbols.print_check(this.token.authority.checks.get(j)))));
            }
            for (int i = 0; i < this.token.blocks.size(); ++i) {
                Block b = this.token.blocks.get(i);
                for (int j2 = 0; j2 < b.checks.size(); ++j2) {
                    checks.add((CallSite)((Object)("Block[" + i + "][" + j2 + "]: " + this.symbols.print_check(b.checks.get(j2)))));
                }
            }
        }
        StringBuilder b = new StringBuilder();
        b.append("World {\n\tfacts: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", facts));
        b.append("\n\t],\n\tprivileged rules: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", privileged_rules));
        b.append("\n\t],\n\trules: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", rules));
        b.append("\n\t],\n\tchecks: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", checks));
        b.append("\n\t]\n}");
        return b.toString();
    }
}

