/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Predicate
implements Serializable {
    private final long name;
    private final List<ID> ids;

    public long name() {
        return this.name;
    }

    public final List<ID> ids() {
        return this.ids;
    }

    public final ListIterator<ID> ids_iterator() {
        return this.ids.listIterator();
    }

    public boolean match(Predicate rule_predicate) {
        if (this.name != rule_predicate.name) {
            return false;
        }
        if (this.ids.size() != rule_predicate.ids.size()) {
            return false;
        }
        for (int i = 0; i < this.ids.size(); ++i) {
            if (this.ids.get(i).match(rule_predicate.ids.get(i))) continue;
            return false;
        }
        return true;
    }

    public Predicate clone() {
        ArrayList<ID> ids = new ArrayList<ID>();
        ids.addAll(this.ids);
        return new Predicate(this.name, ids);
    }

    public Predicate(long name, List<ID> ids) {
        this.name = name;
        this.ids = ids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Predicate predicate = (Predicate)o;
        return this.name == predicate.name && Objects.equals(this.ids, predicate.ids);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ids);
    }

    public String toString() {
        return this.name + "(" + String.join((CharSequence)", ", this.ids.stream().map(i -> i == null ? "(null)" : i.toString()).collect(Collectors.toList())) + ")";
    }

    public Schema.PredicateV1 serialize() {
        Schema.PredicateV1.Builder builder = Schema.PredicateV1.newBuilder().setName(this.name);
        for (int i = 0; i < this.ids.size(); ++i) {
            builder.addIds(this.ids.get(i).serialize());
        }
        return builder.build();
    }

    public static Either<Error.FormatError, Predicate> deserializeV0(Schema.PredicateV0 predicate) {
        ArrayList<ID> ids = new ArrayList<ID>();
        for (Schema.IDV0 id : predicate.getIdsList()) {
            Either<Error.FormatError, ID> res = ID.deserialize_enumV0(id);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            ids.add((ID)res.get());
        }
        return API.Right((Object)new Predicate(predicate.getName(), ids));
    }

    public static Either<Error.FormatError, Predicate> deserializeV1(Schema.PredicateV1 predicate) {
        ArrayList<ID> ids = new ArrayList<ID>();
        for (Schema.IDV1 id : predicate.getIdsList()) {
            Either<Error.FormatError, ID> res = ID.deserialize_enumV1(id);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            ids.add((ID)res.get());
        }
        return API.Right((Object)new Predicate(predicate.getName(), ids));
    }
}

