/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token;

import com.clevercloud.biscuit.crypto.KeyPair;
import com.clevercloud.biscuit.crypto.PublicKey;
import com.clevercloud.biscuit.datalog.Check;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.ID;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.World;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.error.FailedCheck;
import com.clevercloud.biscuit.error.LogicError;
import com.clevercloud.biscuit.token.Block;
import com.clevercloud.biscuit.token.RevocationIdentifier;
import com.clevercloud.biscuit.token.Verifier;
import com.clevercloud.biscuit.token.format.SealedBiscuit;
import com.clevercloud.biscuit.token.format.SerializedBiscuit;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Biscuit {
    final Block authority;
    final List<Block> blocks;
    final SymbolTable symbols;
    final Option<SerializedBiscuit> container;
    final List<byte[]> revocation_ids;

    public static com.clevercloud.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root) {
        return new com.clevercloud.biscuit.token.builder.Biscuit(rng, root, Biscuit.default_symbol_table());
    }

    public static com.clevercloud.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root, SymbolTable symbols) {
        return new com.clevercloud.biscuit.token.builder.Biscuit(rng, root, symbols);
    }

    public static Either<Error, Biscuit> make(SecureRandom rng, KeyPair root, SymbolTable symbols, Block authority) {
        if (!Collections.disjoint(symbols.symbols, authority.symbols.symbols)) {
            return API.Left((Object)new Error.SymbolTableOverlap());
        }
        if (authority.index != 0L) {
            return API.Left((Object)new Error.InvalidAuthorityIndex(authority.index));
        }
        symbols.symbols.addAll(authority.symbols.symbols);
        ArrayList<Block> blocks = new ArrayList<Block>();
        Either<Error.FormatError, SerializedBiscuit> container = SerializedBiscuit.make(rng, root, authority);
        if (container.isLeft()) {
            Error.FormatError e = (Error.FormatError)container.getLeft();
            return API.Left((Object)e);
        }
        SerializedBiscuit s = (SerializedBiscuit)container.get();
        List<byte[]> revocation_ids = s.revocation_identifiers();
        Option c = Option.some((Object)s);
        return API.Right((Object)new Biscuit(authority, blocks, symbols, (Option<SerializedBiscuit>)c, revocation_ids));
    }

    Biscuit(Block authority, List<Block> blocks, SymbolTable symbols, Option<SerializedBiscuit> container, List<byte[]> revocation_ids) {
        this.authority = authority;
        this.blocks = blocks;
        this.symbols = symbols;
        this.container = container;
        this.revocation_ids = revocation_ids;
    }

    public static Either<Error, Biscuit> from_b64(String data) {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data));
    }

    public static Either<Error, Biscuit> from_bytes(byte[] data) {
        return Biscuit.from_bytes_with_symbols(data, Biscuit.default_symbol_table());
    }

    public static Either<Error, Biscuit> from_bytes_with_symbols(byte[] data, SymbolTable symbols) {
        Either<Error, SerializedBiscuit> res = SerializedBiscuit.from_bytes(data);
        if (res.isLeft()) {
            Error e = (Error)res.getLeft();
            return API.Left((Object)e);
        }
        SerializedBiscuit ser = (SerializedBiscuit)res.get();
        Either<Error.FormatError, Block> authRes = Block.from_bytes(ser.authority);
        if (authRes.isLeft()) {
            Error e = (Error)authRes.getLeft();
            return API.Left((Object)e);
        }
        Block authority = (Block)authRes.get();
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (byte[] bdata : ser.blocks) {
            Either<Error.FormatError, Block> blockRes = Block.from_bytes(bdata);
            if (blockRes.isLeft()) {
                Error e = (Error)blockRes.getLeft();
                return API.Left((Object)e);
            }
            blocks.add((Block)blockRes.get());
        }
        for (String s : authority.symbols.symbols) {
            symbols.add(s);
        }
        for (Block b : blocks) {
            for (String s : b.symbols.symbols) {
                symbols.add(s);
            }
        }
        List<byte[]> revocation_ids = ser.revocation_identifiers();
        return API.Right((Object)new Biscuit(authority, blocks, symbols, (Option<SerializedBiscuit>)Option.some((Object)ser), revocation_ids));
    }

    public Either<Error, Verifier> verify(PublicKey root) {
        return Verifier.make(this, (Option<PublicKey>)Option.some((Object)root));
    }

    public Either<Error, Verifier> verify_sealed() {
        return Verifier.make(this, (Option<PublicKey>)Option.none());
    }

    public Either<Error, byte[]> serialize() {
        if (this.container.isEmpty()) {
            return API.Left((Object)new Error.FormatError.SerializationError("no internal container"));
        }
        return ((SerializedBiscuit)this.container.get()).serialize();
    }

    public Either<Error, String> serialize_b64() {
        return this.serialize().map(Base64.getUrlEncoder()::encodeToString);
    }

    public static Either<Error, Biscuit> from_sealed(byte[] data, byte[] secret) {
        SymbolTable symbols = Biscuit.default_symbol_table();
        Either<Error, SealedBiscuit> res = SealedBiscuit.from_bytes(data, secret);
        if (res.isLeft()) {
            Error e = (Error)res.getLeft();
            return API.Left((Object)e);
        }
        SealedBiscuit ser = (SealedBiscuit)res.get();
        Either<Error.FormatError, Block> authRes = Block.from_bytes(ser.authority);
        if (authRes.isLeft()) {
            Error e = (Error)authRes.getLeft();
            return API.Left((Object)e);
        }
        Block authority = (Block)authRes.get();
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (byte[] bdata : ser.blocks) {
            Either<Error.FormatError, Block> blockRes = Block.from_bytes(bdata);
            if (blockRes.isLeft()) {
                Error e = (Error)blockRes.getLeft();
                return API.Left((Object)e);
            }
            blocks.add((Block)blockRes.get());
        }
        for (String s : authority.symbols.symbols) {
            symbols.add(s);
        }
        for (Block b : blocks) {
            for (String s : b.symbols.symbols) {
                symbols.add(s);
            }
        }
        List<byte[]> revocation_ids = ser.revocation_identifiers();
        return API.Right((Object)new Biscuit(authority, blocks, symbols, (Option<SerializedBiscuit>)Option.none(), revocation_ids));
    }

    public Either<Error.FormatError, byte[]> seal(byte[] secret) {
        Either<Error.FormatError, SealedBiscuit> res = SealedBiscuit.make(this.authority, this.blocks, secret);
        if (res.isLeft()) {
            Error.FormatError e = (Error.FormatError)res.getLeft();
            return API.Left((Object)e);
        }
        SealedBiscuit b = (SealedBiscuit)res.get();
        return b.serialize();
    }

    public boolean is_sealed() {
        return this.container.isEmpty();
    }

    public Either<Error, Void> check_root_key(PublicKey public_key) {
        if (this.container.isEmpty()) {
            return API.Left((Object)new Error.Sealed());
        }
        return ((SerializedBiscuit)this.container.get()).check_root_key(public_key);
    }

    Either<Error, World> generate_world() {
        World world = new World();
        long authority_index = (Long)this.symbols.get("authority").get();
        long ambient_index = (Long)this.symbols.get("ambient").get();
        for (Fact fact : this.authority.facts) {
            world.add_fact(fact);
        }
        for (Rule rule : this.authority.rules) {
            world.add_privileged_rule(rule);
        }
        for (int i = 0; i < this.blocks.size(); ++i) {
            Block b = this.blocks.get(i);
            if (b.index != (long)(i + 1)) {
                return API.Left((Object)new Error.InvalidBlockIndex(1 + this.blocks.size(), this.blocks.get((int)i).index));
            }
            for (Fact fact : b.facts) {
                if (fact.predicate().ids().get(0).equals(new ID.Symbol(authority_index)) || fact.predicate().ids().get(0).equals(new ID.Symbol(ambient_index))) {
                    return API.Left((Object)new Error.FailedLogic(new LogicError.InvalidBlockFact(i, this.symbols.print_fact(fact))));
                }
                world.add_fact(fact);
            }
            for (Rule rule : b.rules) {
                world.add_rule(rule);
            }
        }
        List<RevocationIdentifier> revocation_ids = this.revocation_identifiers();
        long rev = (Long)this.symbols.get("revocation_id").get();
        for (int i = 0; i < revocation_ids.size(); ++i) {
            byte[] id = revocation_ids.get(i).getBytes();
            world.add_fact(new Fact(new Predicate(rev, Arrays.asList(new ID.Integer(i), new ID.Bytes(id)))));
        }
        return API.Right((Object)world);
    }

    Either<Error, HashMap<String, Set<Fact>>> check(SymbolTable symbols, List<Fact> ambient_facts, List<Rule> ambient_rules, List<Check> verifier_checks, HashMap<String, Rule> queries) {
        Set<Fact> res;
        int k;
        Check c;
        boolean successful;
        int j;
        Either<Error, World> wres = this.generate_world();
        if (wres.isLeft()) {
            Error e = (Error)wres.getLeft();
            return API.Left((Object)e);
        }
        World world = (World)wres.get();
        for (Fact fact : ambient_facts) {
            world.add_fact(fact);
        }
        for (Rule rule : ambient_rules) {
            world.add_privileged_rule(rule);
        }
        HashSet<Long> restricted_symbols = new HashSet<Long>();
        restricted_symbols.add((Long)symbols.get("authority").get());
        restricted_symbols.add((Long)symbols.get("ambient").get());
        world.run(restricted_symbols);
        ArrayList<FailedCheck> errors = new ArrayList<FailedCheck>();
        for (j = 0; j < this.authority.checks.size(); ++j) {
            successful = false;
            c = this.authority.checks.get(j);
            for (k = 0; k < c.queries().size(); ++k) {
                res = world.query_rule(c.queries().get(k));
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            errors.add(new FailedCheck.FailedBlock(0L, j, symbols.print_check(this.authority.checks.get(j))));
        }
        for (j = 0; j < verifier_checks.size(); ++j) {
            successful = false;
            c = verifier_checks.get(j);
            for (k = 0; k < c.queries().size(); ++k) {
                res = world.query_rule(c.queries().get(k));
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            errors.add(new FailedCheck.FailedVerifier(j, symbols.print_check(verifier_checks.get(j))));
        }
        for (int i = 0; i < this.blocks.size(); ++i) {
            Block b = this.blocks.get(i);
            for (int j2 = 0; j2 < b.checks.size(); ++j2) {
                boolean successful2 = false;
                Check c2 = b.checks.get(j2);
                for (int k2 = 0; k2 < c2.queries().size(); ++k2) {
                    Set<Fact> res2 = world.query_rule(c2.queries().get(k2));
                    if (res2.isEmpty()) continue;
                    successful2 = true;
                    break;
                }
                if (successful2) continue;
                errors.add(new FailedCheck.FailedBlock(b.index, j2, symbols.print_check(b.checks.get(j2))));
            }
        }
        HashMap<String, Set<Fact>> query_results = new HashMap<String, Set<Fact>>();
        for (String name : queries.keySet()) {
            Set<Fact> res3 = world.query_rule(queries.get(name));
            query_results.put(name, res3);
        }
        if (errors.isEmpty()) {
            return API.Right(query_results);
        }
        return API.Left((Object)new Error.FailedLogic(new LogicError.FailedChecks(errors)));
    }

    public com.clevercloud.biscuit.token.builder.Block create_block() {
        return new com.clevercloud.biscuit.token.builder.Block(1 + this.blocks.size(), new SymbolTable(this.symbols));
    }

    public Either<Error, Biscuit> attenuate(SecureRandom rng, KeyPair keypair, Block block) {
        Either<Error, Biscuit> e = this.copy();
        if (e.isLeft()) {
            return API.Left((Object)((Error)e.getLeft()));
        }
        Biscuit copiedBiscuit = (Biscuit)e.get();
        if (!Collections.disjoint(copiedBiscuit.symbols.symbols, block.symbols.symbols)) {
            return API.Left((Object)new Error.SymbolTableOverlap());
        }
        if (block.index != (long)(1 + this.blocks.size())) {
            return API.Left((Object)new Error.InvalidBlockIndex(1 + copiedBiscuit.blocks.size(), block.index));
        }
        Either<Error.FormatError, SerializedBiscuit> containerRes = ((SerializedBiscuit)copiedBiscuit.container.get()).append(rng, keypair, block);
        if (containerRes.isLeft()) {
            Error.FormatError error = (Error.FormatError)containerRes.getLeft();
            return API.Left((Object)error);
        }
        SerializedBiscuit container = (SerializedBiscuit)containerRes.get();
        SymbolTable symbols = new SymbolTable(copiedBiscuit.symbols);
        for (String string : block.symbols.symbols) {
            symbols.add(string);
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Block b : copiedBiscuit.blocks) {
            blocks.add(b);
        }
        blocks.add(block);
        List<byte[]> list = container.revocation_identifiers();
        return API.Right((Object)new Biscuit(copiedBiscuit.authority, blocks, symbols, (Option<SerializedBiscuit>)Option.some((Object)container), list));
    }

    public List<List<Check>> checks() {
        ArrayList<List<Check>> l = new ArrayList<List<Check>>();
        l.add(new ArrayList<Check>(this.authority.checks));
        for (Block b : this.blocks) {
            l.add(new ArrayList<Check>(b.checks));
        }
        return l;
    }

    public List<RevocationIdentifier> revocation_identifiers() {
        return this.revocation_ids.stream().map(e -> RevocationIdentifier.from_bytes(e)).collect(Collectors.toList());
    }

    public List<Option<String>> context() {
        ArrayList<Option<String>> res = new ArrayList<Option<String>>();
        if (this.authority.context.isEmpty()) {
            res.add(Option.none());
        } else {
            res.add(Option.some((Object)this.authority.context));
        }
        for (Block b : this.blocks) {
            if (b.context.isEmpty()) {
                res.add((Option<String>)Option.none());
                continue;
            }
            res.add((Option<String>)Option.some((Object)b.context));
        }
        return res;
    }

    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("Biscuit {\n\tsymbols: ");
        s.append(this.symbols.symbols);
        s.append("\n\tauthority: ");
        s.append(this.authority.print(this.symbols));
        s.append("\n\tblocks: [\n");
        for (Block b : this.blocks) {
            s.append("\t\t");
            s.append(b.print(this.symbols));
            s.append("\n");
        }
        s.append("\t]\n}");
        return s.toString();
    }

    public static SymbolTable default_symbol_table() {
        SymbolTable syms = new SymbolTable();
        syms.insert("authority");
        syms.insert("ambient");
        syms.insert("resource");
        syms.insert("operation");
        syms.insert("right");
        syms.insert("current_time");
        syms.insert("revocation_id");
        return syms;
    }

    public Either<Error, Biscuit> copy() {
        return this.serialize().map(Biscuit::from_bytes).flatMap(e -> {
            Either y = Either.narrow((Either)e);
            return y;
        });
    }
}

