/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token;

import com.clevercloud.biscuit.datalog.RunLimits;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.Term;
import com.clevercloud.biscuit.datalog.World;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.error.FailedCheck;
import com.clevercloud.biscuit.error.LogicError;
import com.clevercloud.biscuit.token.Biscuit;
import com.clevercloud.biscuit.token.Block;
import com.clevercloud.biscuit.token.Policy;
import com.clevercloud.biscuit.token.builder.Check;
import com.clevercloud.biscuit.token.builder.Expression;
import com.clevercloud.biscuit.token.builder.Fact;
import com.clevercloud.biscuit.token.builder.Predicate;
import com.clevercloud.biscuit.token.builder.Rule;
import com.clevercloud.biscuit.token.builder.Term;
import com.clevercloud.biscuit.token.builder.Utils;
import com.clevercloud.biscuit.token.builder.parser.Error;
import com.clevercloud.biscuit.token.builder.parser.Parser;
import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Authorizer {
    Biscuit token;
    List<Check> checks;
    List<List<com.clevercloud.biscuit.datalog.Check>> token_checks;
    List<Policy> policies;
    World world;
    SymbolTable symbols;

    private Authorizer(Biscuit token, World w) throws Error.FailedLogic {
        this.token = token;
        this.world = w;
        this.symbols = new SymbolTable(this.token.symbols);
        this.checks = new ArrayList<Check>();
        this.policies = new ArrayList<Policy>();
        this.token_checks = this.token.checks();
        this.update_on_token();
    }

    public Authorizer() {
        this.world = new World();
        this.symbols = Biscuit.default_symbol_table();
        this.checks = new ArrayList<Check>();
        this.policies = new ArrayList<Policy>();
        this.token_checks = new ArrayList<List<com.clevercloud.biscuit.datalog.Check>>();
    }

    private Authorizer(Biscuit token, List<Check> checks, List<Policy> policies, List<List<com.clevercloud.biscuit.datalog.Check>> token_checks, World world, SymbolTable symbols) {
        this.token = token;
        this.checks = checks;
        this.policies = policies;
        this.token_checks = token_checks;
        this.world = world;
        this.symbols = symbols;
    }

    public static Authorizer make(Biscuit token) throws Error.FailedLogic {
        return new Authorizer(token, new World());
    }

    public Authorizer clone() {
        return new Authorizer(this.token, new ArrayList<Check>(this.checks), new ArrayList<Policy>(this.policies), new ArrayList<List<com.clevercloud.biscuit.datalog.Check>>(this.token_checks), new World(this.world), new SymbolTable(this.symbols));
    }

    public void update_on_token() throws Error.FailedLogic {
        if (this.token != null) {
            for (com.clevercloud.biscuit.datalog.Fact fact : this.token.authority.facts) {
                com.clevercloud.biscuit.datalog.Fact converted_fact = Fact.convert_from(fact, this.token.symbols).convert(this.symbols);
                this.world.add_fact(converted_fact);
            }
            List<byte[]> revocation_ids = this.token.revocation_ids;
            Long revocation_id_sym = (Long)this.symbols.get("revocation_id").get();
            for (int i = 0; i < revocation_ids.size(); ++i) {
                List<com.clevercloud.biscuit.datalog.Term> terms = Arrays.asList(new Term.Integer(i), new Term.Bytes(revocation_ids.get(i)));
                this.world.facts().add(new com.clevercloud.biscuit.datalog.Fact(revocation_id_sym, terms));
            }
            for (com.clevercloud.biscuit.datalog.Rule rule : this.token.authority.rules) {
                Rule _rule = Rule.convert_from(rule, this.token.symbols);
                com.clevercloud.biscuit.datalog.Rule converted_rule = _rule.convert(this.symbols);
                Either<String, Rule> res = _rule.validate_variables();
                if (!res.isLeft()) continue;
                throw new Error.FailedLogic(new LogicError.InvalidBlockRule(0L, this.token.symbols.print_rule(converted_rule)));
            }
        }
    }

    public Authorizer add_token(Biscuit token) throws Error.FailedLogic {
        if (this.token != null) {
            throw new Error.FailedLogic(new LogicError.AuthorizerNotEmpty());
        }
        this.token = token;
        this.update_on_token();
        return this;
    }

    public Authorizer add_fact(Fact fact) {
        this.world.add_fact(fact.convert(this.symbols));
        return this;
    }

    public Authorizer add_fact(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Fact>> res = Parser.fact(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_fact((Fact)t._2);
    }

    public Authorizer add_rule(Rule rule) {
        this.world.add_rule(rule.convert(this.symbols));
        return this;
    }

    public Authorizer add_rule(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_rule((Rule)t._2);
    }

    public Authorizer add_check(Check check) {
        this.checks.add(check);
        return this;
    }

    public Authorizer add_check(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Check>> res = Parser.check(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_check((Check)t._2);
    }

    public Authorizer set_time() throws Error.Language {
        this.world.add_fact(Utils.fact("time", Arrays.asList(Utils.date(new Date()))).convert(this.symbols));
        return this;
    }

    public List<String> get_revocation_ids() throws Error.TooManyFacts, Error.TooManyIterations, Error.Timeout {
        ArrayList<String> ids = new ArrayList<String>();
        Rule getRevocationIds = Utils.rule("revocation_id", Arrays.asList(Utils.var("id")), Arrays.asList(Utils.pred("revocation_id", Arrays.asList(Utils.var("id")))));
        this.query(getRevocationIds).stream().forEach(fact -> fact.terms().stream().forEach(id -> {
            if (id instanceof Term.Str) {
                ids.add(((Term.Str)id).getValue());
            }
        }));
        return ids;
    }

    public Authorizer allow() {
        ArrayList<Rule> q = new ArrayList<Rule>();
        q.add(Utils.constrained_rule("allow", new ArrayList<Term>(), new ArrayList<Predicate>(), Arrays.asList(new Expression.Value(new Term.Bool(true)))));
        this.policies.add(new Policy(q, Policy.Kind.Allow));
        return this;
    }

    public Authorizer deny() {
        ArrayList<Rule> q = new ArrayList<Rule>();
        q.add(Utils.constrained_rule("deny", new ArrayList<Term>(), new ArrayList<Predicate>(), Arrays.asList(new Expression.Value(new Term.Bool(true)))));
        this.policies.add(new Policy(q, Policy.Kind.Deny));
        return this;
    }

    public Authorizer add_policy(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Policy>> res = Parser.policy(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        this.policies.add((Policy)t._2);
        return this;
    }

    public Set<Fact> query(Rule query) throws Error.TooManyFacts, Error.TooManyIterations, Error.Timeout {
        return this.query(query, new RunLimits());
    }

    public Set<Fact> query(String s) throws Error.Parser, Error.TooManyFacts, Error.TooManyIterations, Error.Timeout {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.query((Rule)t._2);
    }

    public Set<Fact> query(Rule query, RunLimits limits) throws Error.TooManyFacts, Error.TooManyIterations, Error.Timeout {
        this.world.run(limits, this.symbols);
        Set<com.clevercloud.biscuit.datalog.Fact> facts = this.world.query_rule(query.convert(this.symbols), this.symbols);
        HashSet<Fact> s = new HashSet<Fact>();
        for (com.clevercloud.biscuit.datalog.Fact f : facts) {
            s.add(Fact.convert_from(f, this.symbols));
        }
        return s;
    }

    public Set<Fact> query(String s, RunLimits limits) throws Error.Parser, Error.TooManyFacts, Error.TooManyIterations, Error.Timeout {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.query((Rule)t._2, limits);
    }

    public Long authorize() throws Error.Timeout, Error.FailedLogic, Error.TooManyFacts, Error.TooManyIterations {
        return this.authorize(new RunLimits());
    }

    public Long authorize(RunLimits limits) throws Error.Timeout, Error.FailedLogic, Error.TooManyFacts, Error.TooManyIterations {
        int i;
        Instant timeLimit = Instant.now().plus(limits.maxTime);
        LinkedList<FailedCheck> errors = new LinkedList<FailedCheck>();
        Option policy_result = Option.none();
        if (this.token != null) {
            for (com.clevercloud.biscuit.datalog.Fact fact : this.token.authority.facts) {
                com.clevercloud.biscuit.datalog.Fact converted_fact = Fact.convert_from(fact, this.token.symbols).convert(this.symbols);
                this.world.add_fact(converted_fact);
            }
            List<byte[]> revocation_ids = this.token.revocation_ids;
            Long revocation_id_sym = (Long)this.symbols.get("revocation_id").get();
            for (int i2 = 0; i2 < revocation_ids.size(); ++i2) {
                List<com.clevercloud.biscuit.datalog.Term> terms = Arrays.asList(new Term.Integer(i2), new Term.Bytes(revocation_ids.get(i2)));
                this.world.facts().add(new com.clevercloud.biscuit.datalog.Fact(revocation_id_sym, terms));
            }
            for (com.clevercloud.biscuit.datalog.Rule rule : this.token.authority.rules) {
                Rule _rule = Rule.convert_from(rule, this.token.symbols);
                com.clevercloud.biscuit.datalog.Rule converted_rule = _rule.convert(this.symbols);
                Either<String, Rule> res = _rule.validate_variables();
                if (!res.isLeft()) continue;
                throw new Error.FailedLogic(new LogicError.InvalidBlockRule(0L, this.token.symbols.print_rule(converted_rule)));
            }
        }
        this.world.run(limits, this.symbols);
        this.world.clearRules();
        for (i = 0; i < this.checks.size(); ++i) {
            com.clevercloud.biscuit.datalog.Check c = this.checks.get(i).convert(this.symbols);
            boolean successful = false;
            for (int j = 0; j < c.queries().size(); ++j) {
                boolean res = this.world.query_match(c.queries().get(j), this.symbols);
                if (Instant.now().compareTo(timeLimit) >= 0) {
                    throw new Error.Timeout();
                }
                if (!res) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            errors.add(new FailedCheck.FailedAuthorizer(i, this.symbols.print_check(c)));
        }
        if (this.token != null) {
            for (int j = 0; j < this.token.authority.checks.size(); ++j) {
                boolean successful = false;
                Check c = Check.convert_from(this.token.authority.checks.get(j), this.symbols);
                com.clevercloud.biscuit.datalog.Check check = c.convert(this.symbols);
                for (int k = 0; k < check.queries().size(); ++k) {
                    boolean res = this.world.query_match(check.queries().get(k), this.symbols);
                    if (Instant.now().compareTo(timeLimit) >= 0) {
                        throw new Error.Timeout();
                    }
                    if (!res) continue;
                    successful = true;
                    break;
                }
                if (successful) continue;
                errors.add(new FailedCheck.FailedBlock(0L, j, this.symbols.print_check(check)));
            }
        }
        block7: for (i = 0; i < this.policies.size(); ++i) {
            Policy policy = this.policies.get(i);
            for (int j = 0; j < policy.queries.size(); ++j) {
                Rule query = policy.queries.get(j);
                boolean res = this.world.query_match(query.convert(this.symbols), this.symbols);
                if (Instant.now().compareTo(timeLimit) >= 0) {
                    throw new Error.Timeout();
                }
                if (!res) continue;
                if (this.policies.get((int)i).kind == Policy.Kind.Allow) {
                    policy_result = Option.some((Object)API.Right((Object)i));
                    break block7;
                }
                policy_result = Option.some((Object)API.Left((Object)i));
                break block7;
            }
        }
        if (this.token != null) {
            for (i = 0; i < this.token.blocks.size(); ++i) {
                Block b = this.token.blocks.get(i);
                for (com.clevercloud.biscuit.datalog.Fact fact : b.facts) {
                    com.clevercloud.biscuit.datalog.Fact converted_fact = Fact.convert_from(fact, this.token.symbols).convert(this.symbols);
                    this.world.add_fact(converted_fact);
                }
                for (com.clevercloud.biscuit.datalog.Rule rule : b.rules) {
                    Rule _rule = Rule.convert_from(rule, this.token.symbols);
                    com.clevercloud.biscuit.datalog.Rule converted_rule = _rule.convert(this.symbols);
                    Either<String, Rule> res = _rule.validate_variables();
                    if (res.isLeft()) {
                        throw new Error.FailedLogic(new LogicError.InvalidBlockRule(0L, this.token.symbols.print_rule(converted_rule)));
                    }
                    this.world.add_rule(converted_rule);
                }
                this.world.run(limits, this.symbols);
                for (int j = 0; j < b.checks.size(); ++j) {
                    boolean successful = false;
                    Check c = Check.convert_from(b.checks.get(j), this.symbols);
                    com.clevercloud.biscuit.datalog.Check check = c.convert(this.symbols);
                    for (int k = 0; k < check.queries().size(); ++k) {
                        boolean res = this.world.query_match(check.queries().get(k), this.symbols);
                        if (Instant.now().compareTo(timeLimit) >= 0) {
                            throw new Error.Timeout();
                        }
                        if (!res) continue;
                        successful = true;
                        break;
                    }
                    if (successful) continue;
                    errors.add(new FailedCheck.FailedBlock(i + 1, j, this.symbols.print_check(check)));
                }
            }
        }
        if (policy_result.isDefined()) {
            Either e = (Either)policy_result.get();
            if (e.isRight()) {
                if (errors.isEmpty()) {
                    return ((Integer)e.get()).longValue();
                }
                throw new Error.FailedLogic(new LogicError.Unauthorized(new LogicError.MatchedPolicy.Allow(((Integer)e.get()).intValue()), errors));
            }
            throw new Error.FailedLogic(new LogicError.Unauthorized(new LogicError.MatchedPolicy.Deny(((Integer)e.getLeft()).intValue()), errors));
        }
        throw new Error.FailedLogic(new LogicError.NoMatchingPolicy(errors));
    }

    public String print_world() {
        int j;
        List facts = this.world.facts().stream().map(f -> this.symbols.print_fact((com.clevercloud.biscuit.datalog.Fact)f)).collect(Collectors.toList());
        List rules = this.world.rules().stream().map(r -> this.symbols.print_rule((com.clevercloud.biscuit.datalog.Rule)r)).collect(Collectors.toList());
        ArrayList<CallSite> checks = new ArrayList<CallSite>();
        for (j = 0; j < this.checks.size(); ++j) {
            checks.add((CallSite)((Object)("Authorizer[" + j + "]: " + this.checks.get(j).toString())));
        }
        if (this.token != null) {
            for (j = 0; j < this.token.authority.checks.size(); ++j) {
                checks.add((CallSite)((Object)("Block[0][" + j + "]: " + this.symbols.print_check(this.token.authority.checks.get(j)))));
            }
            for (int i = 0; i < this.token.blocks.size(); ++i) {
                Block b = this.token.blocks.get(i);
                for (int j2 = 0; j2 < b.checks.size(); ++j2) {
                    checks.add((CallSite)((Object)("Block[" + i + "][" + j2 + "]: " + this.symbols.print_check(b.checks.get(j2)))));
                }
            }
        }
        StringBuilder b = new StringBuilder();
        b.append("World {\n\tfacts: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", facts));
        b.append("\n\t],\n\trules: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", rules));
        b.append("\n\t],\n\tchecks: [\n\t\t");
        b.append(String.join((CharSequence)",\n\t\t", checks));
        b.append("\n\t]\n}");
        return b.toString();
    }
}

