/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token;

import com.clevercloud.biscuit.crypto.KeyPair;
import com.clevercloud.biscuit.crypto.PublicKey;
import com.clevercloud.biscuit.datalog.Check;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.Term;
import com.clevercloud.biscuit.datalog.World;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.error.FailedCheck;
import com.clevercloud.biscuit.error.LogicError;
import com.clevercloud.biscuit.token.Authorizer;
import com.clevercloud.biscuit.token.Block;
import com.clevercloud.biscuit.token.RevocationIdentifier;
import com.clevercloud.biscuit.token.format.SerializedBiscuit;
import com.clevercloud.biscuit.token.format.SignedBlock;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Biscuit {
    final Block authority;
    final List<Block> blocks;
    final SymbolTable symbols;
    final Option<SerializedBiscuit> container;
    final List<byte[]> revocation_ids;

    public static com.clevercloud.biscuit.token.builder.Biscuit builder(KeyPair root) {
        return new com.clevercloud.biscuit.token.builder.Biscuit(new SecureRandom(), root, Biscuit.default_symbol_table());
    }

    public static com.clevercloud.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root) {
        return new com.clevercloud.biscuit.token.builder.Biscuit(rng, root, Biscuit.default_symbol_table());
    }

    public static com.clevercloud.biscuit.token.builder.Biscuit builder(SecureRandom rng, KeyPair root, SymbolTable symbols) {
        return new com.clevercloud.biscuit.token.builder.Biscuit(rng, root, symbols);
    }

    public static Biscuit make(SecureRandom rng, KeyPair root, SymbolTable symbols, Block authority) throws Error.SymbolTableOverlap, Error.FormatError {
        if (!Collections.disjoint(symbols.symbols, authority.symbols.symbols)) {
            throw new Error.SymbolTableOverlap();
        }
        symbols.symbols.addAll(authority.symbols.symbols);
        ArrayList<Block> blocks = new ArrayList<Block>();
        KeyPair next = new KeyPair(rng);
        Either<Error.FormatError, SerializedBiscuit> container = SerializedBiscuit.make(root, authority, next);
        if (container.isLeft()) {
            Error.FormatError e = (Error.FormatError)container.getLeft();
            throw e;
        }
        SerializedBiscuit s = (SerializedBiscuit)container.get();
        List<byte[]> revocation_ids = s.revocation_identifiers();
        Option c = Option.some((Object)s);
        return new Biscuit(authority, blocks, symbols, (Option<SerializedBiscuit>)c, revocation_ids);
    }

    Biscuit(Block authority, List<Block> blocks, SymbolTable symbols, Option<SerializedBiscuit> container, List<byte[]> revocation_ids) {
        this.authority = authority;
        this.blocks = blocks;
        this.symbols = symbols;
        this.container = container;
        this.revocation_ids = revocation_ids;
    }

    @Deprecated
    public static Biscuit from_b64(String data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data), root);
    }

    public static Biscuit from_b64url(String data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes(Base64.getUrlDecoder().decode(data), root);
    }

    public static Biscuit from_bytes(byte[] data, PublicKey root) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.from_bytes_with_symbols(data, root, Biscuit.default_symbol_table());
    }

    public static Biscuit from_bytes_with_symbols(byte[] data, PublicKey root, SymbolTable symbols) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        SerializedBiscuit ser = SerializedBiscuit.from_bytes(data, root);
        return Biscuit.from_serialize_biscuit(ser, symbols);
    }

    static Biscuit from_serialize_biscuit(SerializedBiscuit ser, SymbolTable symbols) throws Error {
        Either<Error.FormatError, Block> authRes = Block.from_bytes(ser.authority.block);
        if (authRes.isLeft()) {
            Error e = (Error)authRes.getLeft();
            throw e;
        }
        Block authority = (Block)authRes.get();
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (SignedBlock bdata : ser.blocks) {
            Either<Error.FormatError, Block> blockRes = Block.from_bytes(bdata.block);
            if (blockRes.isLeft()) {
                Error e = (Error)blockRes.getLeft();
                throw e;
            }
            blocks.add((Block)blockRes.get());
        }
        for (String s : authority.symbols.symbols) {
            symbols.add(s);
        }
        for (Block b : blocks) {
            for (String s : b.symbols.symbols) {
                symbols.add(s);
            }
        }
        List<byte[]> revocation_ids = ser.revocation_identifiers();
        return new Biscuit(authority, blocks, symbols, (Option<SerializedBiscuit>)Option.some((Object)ser), revocation_ids);
    }

    static Biscuit unsafe_from_bytes(byte[] data, SymbolTable symbols) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        Either<Error, SerializedBiscuit> res = SerializedBiscuit.unsafe_deserialize(data);
        if (res.isLeft()) {
            Error e = (Error)res.getLeft();
            throw e;
        }
        SerializedBiscuit ser = (SerializedBiscuit)res.get();
        return Biscuit.from_serialize_biscuit(ser, symbols);
    }

    public Authorizer authorizer() throws Error.FailedLogic {
        return Authorizer.make(this);
    }

    public byte[] serialize() throws Error.FormatError.SerializationError {
        if (this.container.isEmpty()) {
            throw new Error.FormatError.SerializationError("no internal container");
        }
        return ((SerializedBiscuit)this.container.get()).serialize();
    }

    @Deprecated
    public String serialize_b64() throws Error.FormatError.SerializationError {
        return Base64.getUrlEncoder().encodeToString(this.serialize());
    }

    public String serialize_b64url() throws Error.FormatError.SerializationError {
        return Base64.getUrlEncoder().encodeToString(this.serialize());
    }

    public byte[] seal() throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        if (this.container.isEmpty()) {
            throw new Error.FormatError.SerializationError("no internal container");
        }
        SerializedBiscuit ser = (SerializedBiscuit)this.container.get();
        Either<Error, Void> res = ser.seal();
        if (res.isLeft()) {
            throw (Error)res.getLeft();
        }
        return ser.serialize();
    }

    public boolean is_sealed() {
        return this.container.isEmpty() || ((SerializedBiscuit)this.container.get()).proof.secretKey.isEmpty();
    }

    Either<Error, World> generate_world() {
        World world = new World();
        for (Fact fact : this.authority.facts) {
            world.add_fact(fact);
        }
        for (Rule rule : this.authority.rules) {
            world.add_rule(rule);
        }
        for (int i = 0; i < this.blocks.size(); ++i) {
            Block b = this.blocks.get(i);
            for (Fact fact : b.facts) {
                world.add_fact(fact);
            }
            for (Rule rule : b.rules) {
                world.add_rule(rule);
            }
        }
        List<RevocationIdentifier> revocation_ids = this.revocation_identifiers();
        long rev = (Long)this.symbols.get("revocation_id").get();
        for (int i = 0; i < revocation_ids.size(); ++i) {
            byte[] id = revocation_ids.get(i).getBytes();
            world.add_fact(new Fact(new Predicate(rev, Arrays.asList(new Term.Integer(i), new Term.Bytes(id)))));
        }
        return API.Right((Object)world);
    }

    HashMap<String, Set<Fact>> check(SymbolTable symbols, List<Fact> ambient_facts, List<Rule> ambient_rules, List<Check> authorizer_checks, HashMap<String, Rule> queries) throws Error {
        Set<Fact> res;
        int k;
        Check c;
        boolean successful;
        int j;
        Either<Error, World> wres = this.generate_world();
        if (wres.isLeft()) {
            Error e = (Error)wres.getLeft();
            throw e;
        }
        World world = (World)wres.get();
        for (Fact fact : ambient_facts) {
            world.add_fact(fact);
        }
        for (Rule rule : ambient_rules) {
            world.add_rule(rule);
        }
        world.run(symbols);
        ArrayList<FailedCheck> errors = new ArrayList<FailedCheck>();
        for (j = 0; j < this.authority.checks.size(); ++j) {
            successful = false;
            c = this.authority.checks.get(j);
            for (k = 0; k < c.queries().size(); ++k) {
                res = world.query_rule(c.queries().get(k), symbols);
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            errors.add(new FailedCheck.FailedBlock(0L, j, symbols.print_check(this.authority.checks.get(j))));
        }
        for (j = 0; j < authorizer_checks.size(); ++j) {
            successful = false;
            c = authorizer_checks.get(j);
            for (k = 0; k < c.queries().size(); ++k) {
                res = world.query_rule(c.queries().get(k), symbols);
                if (res.isEmpty()) continue;
                successful = true;
                break;
            }
            if (successful) continue;
            errors.add(new FailedCheck.FailedAuthorizer(j + 1, symbols.print_check(authorizer_checks.get(j))));
        }
        for (int i = 0; i < this.blocks.size(); ++i) {
            Block b = this.blocks.get(i);
            for (int j2 = 0; j2 < b.checks.size(); ++j2) {
                boolean successful2 = false;
                Check c2 = b.checks.get(j2);
                for (int k2 = 0; k2 < c2.queries().size(); ++k2) {
                    Set<Fact> res2 = world.query_rule(c2.queries().get(k2), symbols);
                    if (res2.isEmpty()) continue;
                    successful2 = true;
                    break;
                }
                if (successful2) continue;
                errors.add(new FailedCheck.FailedBlock(i + 1, j2, symbols.print_check(b.checks.get(j2))));
            }
        }
        HashMap<String, Set<Fact>> query_results = new HashMap<String, Set<Fact>>();
        for (String name : queries.keySet()) {
            Set<Fact> res3 = world.query_rule(queries.get(name), symbols);
            query_results.put(name, res3);
        }
        if (errors.isEmpty()) {
            return query_results;
        }
        throw new Error.FailedLogic(new LogicError.Unauthorized(new LogicError.MatchedPolicy.Allow(0L), errors));
    }

    public com.clevercloud.biscuit.token.builder.Block create_block() {
        return new com.clevercloud.biscuit.token.builder.Block(1 + this.blocks.size(), new SymbolTable(this.symbols));
    }

    public Biscuit attenuate(com.clevercloud.biscuit.token.builder.Block block) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        SecureRandom rng = new SecureRandom();
        KeyPair keypair = new KeyPair(rng);
        return this.attenuate(rng, keypair, block.build());
    }

    public Biscuit attenuate(SecureRandom rng, KeyPair keypair, Block block) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        Biscuit copiedBiscuit = this.copy();
        if (!Collections.disjoint(copiedBiscuit.symbols.symbols, block.symbols.symbols)) {
            throw new Error.SymbolTableOverlap();
        }
        Either<Error.FormatError, SerializedBiscuit> containerRes = ((SerializedBiscuit)copiedBiscuit.container.get()).append(keypair, block);
        if (containerRes.isLeft()) {
            Error.FormatError error = (Error.FormatError)containerRes.getLeft();
            throw error;
        }
        SerializedBiscuit container = (SerializedBiscuit)containerRes.get();
        SymbolTable symbols = new SymbolTable(copiedBiscuit.symbols);
        for (String string : block.symbols.symbols) {
            symbols.add(string);
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Block b : copiedBiscuit.blocks) {
            blocks.add(b);
        }
        blocks.add(block);
        List<byte[]> list = container.revocation_identifiers();
        return new Biscuit(copiedBiscuit.authority, blocks, symbols, (Option<SerializedBiscuit>)Option.some((Object)container), list);
    }

    public List<List<Check>> checks() {
        ArrayList<List<Check>> l = new ArrayList<List<Check>>();
        l.add(new ArrayList<Check>(this.authority.checks));
        for (Block b : this.blocks) {
            l.add(new ArrayList<Check>(b.checks));
        }
        return l;
    }

    public List<RevocationIdentifier> revocation_identifiers() {
        return this.revocation_ids.stream().map(e -> RevocationIdentifier.from_bytes(e)).collect(Collectors.toList());
    }

    public List<Option<String>> context() {
        ArrayList<Option<String>> res = new ArrayList<Option<String>>();
        if (this.authority.context.isEmpty()) {
            res.add(Option.none());
        } else {
            res.add(Option.some((Object)this.authority.context));
        }
        for (Block b : this.blocks) {
            if (b.context.isEmpty()) {
                res.add((Option<String>)Option.none());
                continue;
            }
            res.add((Option<String>)Option.some((Object)b.context));
        }
        return res;
    }

    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("Biscuit {\n\tsymbols: ");
        s.append(this.symbols.symbols);
        s.append("\n\tauthority: ");
        s.append(this.authority.print(this.symbols));
        s.append("\n\tblocks: [\n");
        for (Block b : this.blocks) {
            s.append("\t\t");
            s.append(b.print(this.symbols));
            s.append("\n");
        }
        s.append("\t]\n}");
        return s.toString();
    }

    public static SymbolTable default_symbol_table() {
        SymbolTable syms = new SymbolTable();
        syms.insert("authority");
        syms.insert("ambient");
        syms.insert("resource");
        syms.insert("operation");
        syms.insert("right");
        syms.insert("current_time");
        syms.insert("revocation_id");
        return syms;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Biscuit copy() throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, Error {
        return Biscuit.unsafe_from_bytes(this.serialize(), this.symbols);
    }
}

