/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.crypto.KeyPair;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.token.Block;
import com.clevercloud.biscuit.token.builder.Check;
import com.clevercloud.biscuit.token.builder.Fact;
import com.clevercloud.biscuit.token.builder.Rule;
import com.clevercloud.biscuit.token.builder.Utils;
import com.clevercloud.biscuit.token.builder.parser.Error;
import com.clevercloud.biscuit.token.builder.parser.Parser;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Biscuit {
    SecureRandom rng;
    KeyPair root;
    int symbol_start;
    SymbolTable symbols;
    String context;
    List<com.clevercloud.biscuit.datalog.Fact> facts;
    List<com.clevercloud.biscuit.datalog.Rule> rules;
    List<com.clevercloud.biscuit.datalog.Check> checks;

    public Biscuit(SecureRandom rng, KeyPair root, SymbolTable base_symbols) {
        this.rng = rng;
        this.root = root;
        this.symbol_start = base_symbols.symbols.size();
        this.symbols = new SymbolTable(base_symbols);
        this.context = "";
        this.facts = new ArrayList<com.clevercloud.biscuit.datalog.Fact>();
        this.rules = new ArrayList<com.clevercloud.biscuit.datalog.Rule>();
        this.checks = new ArrayList<com.clevercloud.biscuit.datalog.Check>();
    }

    public Biscuit add_authority_fact(Fact f) throws Error.Language {
        f.validate();
        this.facts.add(f.convert(this.symbols));
        return this;
    }

    public Biscuit add_authority_fact(String s) throws Error.Parser, Error.Language {
        Either<Error, Tuple2<String, Fact>> res = Parser.fact(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_authority_fact((Fact)t._2);
    }

    public Biscuit add_authority_rule(Rule rule) {
        this.rules.add(rule.convert(this.symbols));
        return this;
    }

    public Biscuit add_authority_rule(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Rule>> res = Parser.rule(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_authority_rule((Rule)t._2);
    }

    public Biscuit add_authority_check(Check c) {
        this.checks.add(c.convert(this.symbols));
        return this;
    }

    public Biscuit add_authority_check(String s) throws Error.Parser {
        Either<Error, Tuple2<String, Check>> res = Parser.check(s);
        if (res.isLeft()) {
            throw new Error.Parser((Error)res.getLeft());
        }
        Tuple2 t = (Tuple2)res.get();
        return this.add_authority_check((Check)t._2);
    }

    public Biscuit set_context(String context) {
        this.context = context;
        return this;
    }

    public com.clevercloud.biscuit.token.Biscuit build() throws com.clevercloud.biscuit.error.Error {
        int i;
        SymbolTable base_symbols = new SymbolTable();
        SymbolTable symbols = new SymbolTable();
        for (i = 0; i < this.symbol_start; ++i) {
            base_symbols.add(this.symbols.symbols.get(i));
        }
        for (i = this.symbol_start; i < this.symbols.symbols.size(); ++i) {
            symbols.add(this.symbols.symbols.get(i));
        }
        Block authority_block = new Block(symbols, this.context, this.facts, this.rules, this.checks);
        return com.clevercloud.biscuit.token.Biscuit.make(this.rng, this.root, base_symbols, authority_block);
    }

    public Biscuit add_right(String resource, String right) throws Error.Language {
        return this.add_authority_fact(Utils.fact("right", Arrays.asList(Utils.string(resource), Utils.s(right))));
    }
}

