/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.crypto;

import com.clevercloud.biscuit.crypto.KeyPair;
import com.clevercloud.biscuit.crypto.PublicKey;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.ArrayList;
import net.i2p.crypto.eddsa.EdDSAEngine;

class Token {
    public final ArrayList<byte[]> blocks;
    public final ArrayList<PublicKey> keys;
    public final ArrayList<byte[]> signatures;
    public final KeyPair next;

    public Token(KeyPair rootKeyPair, byte[] message, KeyPair next) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
        ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        algo_buf.putInt(next.public_key().algorithm.getNumber());
        algo_buf.flip();
        sgr.initSign((PrivateKey)rootKeyPair.private_key);
        sgr.update(message);
        sgr.update(algo_buf);
        sgr.update(next.public_key().toBytes());
        byte[] signature = sgr.sign();
        this.blocks = new ArrayList();
        this.blocks.add(message);
        this.keys = new ArrayList();
        this.keys.add(next.public_key());
        this.signatures = new ArrayList();
        this.signatures.add(signature);
        this.next = next;
    }

    public Token(ArrayList<byte[]> blocks, ArrayList<PublicKey> keys, ArrayList<byte[]> signatures, KeyPair next) {
        this.signatures = signatures;
        this.blocks = blocks;
        this.keys = keys;
        this.next = next;
    }

    public Token append(KeyPair keyPair, byte[] message) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
        sgr.initSign((PrivateKey)this.next.private_key);
        ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        algo_buf.putInt(this.next.public_key().algorithm.getNumber());
        algo_buf.flip();
        sgr.update(message);
        sgr.update(algo_buf);
        sgr.update(keyPair.public_key().toBytes());
        byte[] signature = sgr.sign();
        Token token = new Token(this.blocks, this.keys, this.signatures, keyPair);
        token.blocks.add(message);
        token.signatures.add(signature);
        token.keys.add(keyPair.public_key());
        return token;
    }

    public Either<Error, Void> verify(PublicKey root) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        PublicKey current_key = root;
        for (int i = 0; i < this.blocks.size(); ++i) {
            byte[] block = this.blocks.get(i);
            PublicKey next_key = this.keys.get(i);
            byte[] signature = this.signatures.get(i);
            System.out.println("verifying block " + i + " with current key " + current_key.toHex() + " block " + block + " next key " + next_key.toHex() + " signature " + signature);
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(KeyPair.ed25519.getHashAlgorithm()));
            ByteBuffer algo_buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            algo_buf.putInt(this.next.public_key().algorithm.getNumber());
            algo_buf.flip();
            sgr.initVerify((java.security.PublicKey)current_key.key);
            sgr.update(block);
            sgr.update(algo_buf);
            sgr.update(next_key.toBytes());
            if (!sgr.verify(signature)) {
                System.out.println("signature not verified");
                return API.Left((Object)new Error.FormatError.Signature.InvalidSignature("signature error: Verification equation was not satisfied"));
            }
            current_key = next_key;
        }
        if (this.next.public_key == current_key.key) {
            return API.Right(null);
        }
        System.out.println("current key and next public key not equal:");
        System.out.println("current: " + current_key.toHex());
        System.out.println("next: " + this.next.public_key().toHex());
        return API.Left((Object)new Error.FormatError.Signature.InvalidSignature("signature error: Verification equation was not satisfied"));
    }
}

