/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.Combinator;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.MatchedVariables;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.Term;
import com.clevercloud.biscuit.datalog.expressions.Expression;
import com.clevercloud.biscuit.error.Error;
import io.vavr.API;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Rule
implements Serializable {
    private final Predicate head;
    private final List<Predicate> body;
    private final List<Expression> expressions;

    public final Predicate head() {
        return this.head;
    }

    public final List<Predicate> body() {
        return this.body;
    }

    public final List<Expression> expressions() {
        return this.expressions;
    }

    public void apply(Set<Fact> facts, Set<Fact> new_facts, SymbolTable symbols) {
        ListIterator<Term> idit;
        Predicate p;
        Option<Map<Long, Term>> h_opt;
        HashSet<Long> variables_set = new HashSet<Long>();
        for (Predicate pred : this.body) {
            variables_set.addAll(pred.terms().stream().filter(id -> id instanceof Term.Variable).map(id -> ((Term.Variable)id).value()).collect(Collectors.toSet()));
        }
        MatchedVariables variables = new MatchedVariables(variables_set);
        if (this.body.isEmpty() && (h_opt = variables.check_expressions(this.expressions, symbols)).isDefined()) {
            Map<Long, Term> h = (Map<Long, Term>)h_opt.get();
            p = this.head.clone();
            idit = p.ids_iterator();
            while (idit.hasNext()) {
                Term id2 = idit.next();
                if (!(id2 instanceof Term.Variable)) continue;
                Term value = h.get(((Term.Variable)id2).value());
                idit.set(value);
            }
            new_facts.add(new Fact(p));
        }
        for (Map<Long, Term> h : new Combinator(variables, this.body, this.expressions, facts, symbols).combine()) {
            p = this.head.clone();
            idit = p.ids_iterator();
            boolean unbound_variable = false;
            while (idit.hasNext()) {
                Term id3 = idit.next();
                if (!(id3 instanceof Term.Variable)) continue;
                Term value = h.get(((Term.Variable)id3).value());
                idit.set(value);
                if (value != null) continue;
                unbound_variable = true;
            }
            if (unbound_variable) continue;
            new_facts.add(new Fact(p));
        }
    }

    public boolean find_match(Set<Fact> facts, SymbolTable symbols) {
        HashSet<Long> variables_set = new HashSet<Long>();
        for (Predicate pred : this.body) {
            variables_set.addAll(pred.terms().stream().filter(id -> id instanceof Term.Variable).map(id -> ((Term.Variable)id).value()).collect(Collectors.toSet()));
        }
        MatchedVariables variables = new MatchedVariables(variables_set);
        if (this.body.isEmpty()) {
            return variables.check_expressions(this.expressions, symbols).isDefined();
        }
        Combinator c = new Combinator(variables, this.body, this.expressions, facts, symbols);
        return c.next().isDefined();
    }

    public Rule(Predicate head, List<Predicate> body, List<Expression> expressions) {
        this.head = head;
        this.body = body;
        this.expressions = expressions;
    }

    public Schema.RuleV2 serialize() {
        int i;
        Schema.RuleV2.Builder b = Schema.RuleV2.newBuilder().setHead(this.head.serialize());
        for (i = 0; i < this.body.size(); ++i) {
            b.addBody(this.body.get(i).serialize());
        }
        for (i = 0; i < this.expressions.size(); ++i) {
            b.addExpressions(this.expressions.get(i).serialize());
        }
        return b.build();
    }

    public static Either<Error.FormatError, Rule> deserializeV2(Schema.RuleV2 rule) {
        ArrayList<Predicate> body = new ArrayList<Predicate>();
        for (Schema.PredicateV2 predicateV2 : rule.getBodyList()) {
            Either<Error.FormatError, Predicate> res = Predicate.deserializeV2(predicateV2);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            body.add((Predicate)res.get());
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (Schema.ExpressionV2 expression : rule.getExpressionsList()) {
            Either<Error.FormatError, Expression> res = Expression.deserializeV2(expression);
            if (res.isLeft()) {
                Error.FormatError e = (Error.FormatError)res.getLeft();
                return API.Left((Object)e);
            }
            expressions.add((Expression)res.get());
        }
        Either<Error.FormatError, Predicate> either = Predicate.deserializeV2(rule.getHead());
        if (either.isLeft()) {
            Error.FormatError e = (Error.FormatError)either.getLeft();
            return API.Left((Object)e);
        }
        return API.Right((Object)new Rule((Predicate)either.get(), body, expressions));
    }
}

