/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.Term;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

public abstract class Term {
    public abstract com.clevercloud.biscuit.datalog.Term convert(SymbolTable var1);

    public static Term convert_from(com.clevercloud.biscuit.datalog.Term id, SymbolTable symbols) {
        return id.toTerm(symbols);
    }

    public static class Set
    extends Term {
        HashSet<Term> value;

        public Set(HashSet<Term> value) {
            this.value = value;
        }

        @Override
        public com.clevercloud.biscuit.datalog.Term convert(SymbolTable symbols) {
            HashSet<com.clevercloud.biscuit.datalog.Term> s = new HashSet<com.clevercloud.biscuit.datalog.Term>();
            for (Term t : this.value) {
                s.add(t.convert(symbols));
            }
            return new Term.Set(s);
        }

        public String toString() {
            return "[" + this.value + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Set set = (Set)o;
            return this.value != null ? this.value.equals(set.value) : set.value == null;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static class Bool
    extends Term {
        boolean value;

        public Bool(boolean value) {
            this.value = value;
        }

        @Override
        public com.clevercloud.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Bool(this.value);
        }

        public String toString() {
            return "" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bool bool = (Bool)o;
            return this.value == bool.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }
    }

    public static class Date
    extends Term {
        long value;

        public Date(long value) {
            this.value = value;
        }

        @Override
        public com.clevercloud.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Date(this.value);
        }

        public String toString() {
            return "" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Date date = (Date)o;
            return this.value == date.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    public static class Bytes
    extends Term {
        byte[] value;

        public Bytes(byte[] value) {
            this.value = value;
        }

        @Override
        public com.clevercloud.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Bytes(this.value);
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bytes bytes = (Bytes)o;
            return Arrays.equals(this.value, bytes.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }
    }

    public static class Integer
    extends Term {
        long value;

        public Integer(long value) {
            this.value = value;
        }

        @Override
        public com.clevercloud.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Integer(this.value);
        }

        public String toString() {
            return "" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Integer integer = (Integer)o;
            return this.value == integer.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    public static class Variable
    extends Term {
        String value;

        public Variable(String value) {
            this.value = value;
        }

        @Override
        public com.clevercloud.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Variable(symbols.insert(this.value));
        }

        public String toString() {
            return "$" + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return this.value.equals(variable.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static class Str
    extends Term {
        String value;

        public String getValue() {
            return this.value;
        }

        public Str(String value) {
            this.value = value;
        }

        @Override
        public com.clevercloud.biscuit.datalog.Term convert(SymbolTable symbols) {
            return new Term.Str(symbols.insert(this.value));
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Str s = (Str)o;
            return Objects.equals(this.value, s.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

