/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.crypto;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.crypto.KeyPair;
import com.clevercloud.biscuit.token.builder.Utils;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class PublicKey {
    public final EdDSAPublicKey key;
    public final Schema.PublicKey.Algorithm algorithm;

    public PublicKey(Schema.PublicKey.Algorithm algorithm, EdDSAPublicKey public_key) {
        this.key = public_key;
        this.algorithm = algorithm;
    }

    public PublicKey(Schema.PublicKey.Algorithm algorithm, byte[] data) {
        EdDSAPublicKey pubKey;
        EdDSAPublicKeySpec pubKeySpec = new EdDSAPublicKeySpec(data, (EdDSAParameterSpec)KeyPair.ed25519);
        this.key = pubKey = new EdDSAPublicKey(pubKeySpec);
        this.algorithm = algorithm;
    }

    public byte[] toBytes() {
        return this.key.getAbyte();
    }

    public String toHex() {
        return Utils.byteArrayToHexString(this.toBytes());
    }

    public PublicKey(Schema.PublicKey.Algorithm algorithm, String hex) {
        EdDSAPublicKey pubKey;
        byte[] data = Utils.hexStringToByteArray(hex);
        EdDSAPublicKeySpec pubKeySpec = new EdDSAPublicKeySpec(data, (EdDSAParameterSpec)KeyPair.ed25519);
        this.key = pubKey = new EdDSAPublicKey(pubKeySpec);
        this.algorithm = algorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKey publicKey = (PublicKey)o;
        return this.key.equals((Object)publicKey.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

