/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.datalog;

import com.clevercloud.biscuit.datalog.Check;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.Predicate;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.datalog.RunLimits;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.datalog.Term;
import com.clevercloud.biscuit.error.Error;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class World
implements Serializable {
    private final Set<Fact> facts;
    private final List<Rule> rules;

    public void add_fact(Fact fact) {
        this.facts.add(fact);
    }

    public void add_facts(Set<Fact> facts) {
        this.facts.addAll(facts);
    }

    public void add_rule(Rule rule) {
        this.rules.add(rule);
    }

    public void clearRules() {
        this.rules.clear();
    }

    public void run(SymbolTable symbols) throws Error.TooManyFacts, Error.TooManyIterations, Error.Timeout {
        this.run(new RunLimits(), symbols);
    }

    public void run(RunLimits limits, SymbolTable symbols) throws Error.TooManyFacts, Error.TooManyIterations, Error.Timeout {
        int iterations = 0;
        Instant limit = Instant.now().plus(limits.maxTime);
        do {
            HashSet<Fact> new_facts = new HashSet<Fact>();
            for (Rule rule : this.rules) {
                rule.apply(this.facts, new_facts, symbols);
                if (Instant.now().compareTo(limit) < 0) continue;
                throw new Error.Timeout();
            }
            int len = this.facts.size();
            this.facts.addAll(new_facts);
            if (this.facts.size() == len) {
                return;
            }
            if (this.facts.size() < limits.maxFacts) continue;
            throw new Error.TooManyFacts();
        } while (++iterations < limits.maxIterations);
        throw new Error.TooManyIterations();
    }

    public final Set<Fact> facts() {
        return this.facts;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public final Set<Fact> query(Predicate pred) {
        return this.facts.stream().filter(f -> {
            if (f.predicate().name() != pred.name()) {
                return false;
            }
            int min_size = Math.min(f.predicate().terms().size(), pred.terms().size());
            for (int i = 0; i < min_size; ++i) {
                Term fid = f.predicate().terms().get(i);
                Term pid = pred.terms().get(i);
                if (!(fid instanceof Term.Integer) && !(fid instanceof Term.Str) && !(fid instanceof Term.Date) || fid.getClass() != pid.getClass() || fid.equals(pid)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toSet());
    }

    public final Set<Fact> query_rule(Rule rule, SymbolTable symbols) {
        HashSet<Fact> new_facts = new HashSet<Fact>();
        rule.apply(this.facts, new_facts, symbols);
        return new_facts;
    }

    public final boolean query_match(Rule rule, SymbolTable symbols) {
        return rule.find_match(this.facts, symbols);
    }

    public World() {
        this.facts = new HashSet<Fact>();
        this.rules = new ArrayList<Rule>();
    }

    public World(Set<Fact> facts) {
        this.facts = new HashSet<Fact>();
        this.facts.addAll(facts);
        this.rules = new ArrayList<Rule>();
    }

    public World(Set<Fact> facts, List<Rule> rules) {
        this.facts = facts;
        this.rules = rules;
    }

    public World(Set<Fact> facts, List<Rule> rules, List<Check> checks) {
        this.facts = facts;
        this.rules = rules;
    }

    public World(World w) {
        this.facts = new HashSet<Fact>();
        for (Fact fact : w.facts) {
            this.facts.add(fact);
        }
        this.rules = new ArrayList<Rule>();
        for (Rule rule : w.rules) {
            this.rules.add(rule);
        }
    }

    public String print(SymbolTable symbol_table) {
        StringBuilder s = new StringBuilder();
        s.append("World {\n\t\tfacts: [");
        for (Fact f : this.facts) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_fact(f));
        }
        s.append("\n\t\t]\n\t\trules: [");
        for (Rule r : this.rules) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_rule(r));
        }
        s.append("\n\t\t]\n\t}");
        return s.toString();
    }
}

