/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token;

import biscuit.format.schema.Schema;
import com.clevercloud.biscuit.datalog.Check;
import com.clevercloud.biscuit.datalog.Fact;
import com.clevercloud.biscuit.datalog.Rule;
import com.clevercloud.biscuit.datalog.SymbolTable;
import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.token.format.SerializedBiscuit;
import com.google.protobuf.InvalidProtocolBufferException;
import io.vavr.API;
import io.vavr.control.Either;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Block {
    final SymbolTable symbols;
    final String context;
    final List<Fact> facts;
    final List<Rule> rules;
    final List<Check> checks;
    final long version;

    public Block(SymbolTable base_symbols) {
        this.symbols = base_symbols;
        this.context = "";
        this.facts = new ArrayList<Fact>();
        this.rules = new ArrayList<Rule>();
        this.checks = new ArrayList<Check>();
        this.version = SerializedBiscuit.MAX_SCHEMA_VERSION;
    }

    public Block(SymbolTable base_symbols, String context, List<Fact> facts, List<Rule> rules, List<Check> checks) {
        this.symbols = base_symbols;
        this.context = context;
        this.facts = facts;
        this.rules = rules;
        this.checks = checks;
        this.version = SerializedBiscuit.MAX_SCHEMA_VERSION;
    }

    public String print(SymbolTable symbol_table) {
        StringBuilder s = new StringBuilder();
        s.append("Block");
        s.append(" {\n\t\tsymbols: ");
        s.append(this.symbols.symbols);
        s.append("\n\t\tcontext: ");
        s.append(this.context);
        s.append("\n\t\tfacts: [");
        for (Fact f : this.facts) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_fact(f));
        }
        s.append("\n\t\t]\n\t\trules: [");
        for (Rule r : this.rules) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_rule(r));
        }
        s.append("\n\t\t]\n\t\tchecks: [");
        for (Check c : this.checks) {
            s.append("\n\t\t\t");
            s.append(symbol_table.print_check(c));
        }
        s.append("\n\t\t]\n\t}");
        return s.toString();
    }

    public Schema.Block serialize() {
        int i;
        Schema.Block.Builder b = Schema.Block.newBuilder();
        for (i = 0; i < this.symbols.symbols.size(); ++i) {
            b.addSymbols(this.symbols.symbols.get(i));
        }
        if (!this.context.isEmpty()) {
            b.setContext(this.context);
        }
        for (i = 0; i < this.facts.size(); ++i) {
            b.addFactsV2(this.facts.get(i).serialize());
        }
        for (i = 0; i < this.rules.size(); ++i) {
            b.addRulesV2(this.rules.get(i).serialize());
        }
        for (i = 0; i < this.checks.size(); ++i) {
            b.addChecksV2(this.checks.get(i).serialize());
        }
        b.setVersion(SerializedBiscuit.MAX_SCHEMA_VERSION);
        return b.build();
    }

    public static Either<Error.FormatError, Block> deserialize(Schema.Block b) {
        int version = b.getVersion();
        if (version < SerializedBiscuit.MIN_SCHEMA_VERSION || version > SerializedBiscuit.MAX_SCHEMA_VERSION) {
            return API.Left((Object)new Error.FormatError.Version(SerializedBiscuit.MIN_SCHEMA_VERSION, SerializedBiscuit.MAX_SCHEMA_VERSION, version));
        }
        SymbolTable symbols = new SymbolTable();
        for (String s : b.getSymbolsList()) {
            symbols.add(s);
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Check> checks = new ArrayList<Check>();
        if (version == 3) {
            Object res;
            for (Schema.FactV2 fact : b.getFactsV2List()) {
                res = Fact.deserializeV2(fact);
                if (res.isLeft()) {
                    Error.FormatError e = (Error.FormatError)res.getLeft();
                    return API.Left((Object)e);
                }
                facts.add((Fact)res.get());
            }
            for (Schema.RuleV2 rule : b.getRulesV2List()) {
                res = Rule.deserializeV2(rule);
                if (res.isLeft()) {
                    Error.FormatError e = (Error.FormatError)res.getLeft();
                    return API.Left((Object)e);
                }
                rules.add((Rule)res.get());
            }
            for (Schema.CheckV2 check : b.getChecksV2List()) {
                res = Check.deserializeV2(check);
                if (res.isLeft()) {
                    Error.FormatError e = (Error.FormatError)res.getLeft();
                    return API.Left((Object)e);
                }
                checks.add((Check)res.get());
            }
            return API.Right((Object)new Block(symbols, b.getContext(), facts, rules, checks));
        }
        return API.Left((Object)new Error.FormatError.Version(SerializedBiscuit.MIN_SCHEMA_VERSION, SerializedBiscuit.MAX_SCHEMA_VERSION, version));
    }

    public static Either<Error.FormatError, Block> from_bytes(byte[] slice) {
        try {
            Schema.Block data = Schema.Block.parseFrom(slice);
            return Block.deserialize(data);
        }
        catch (InvalidProtocolBufferException e) {
            return API.Left((Object)new Error.FormatError.DeserializationError(e.toString()));
        }
    }

    public Either<Error.FormatError, byte[]> to_bytes() {
        Schema.Block b = this.serialize();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            b.writeTo(stream);
            byte[] data = stream.toByteArray();
            return API.Right((Object)data);
        }
        catch (IOException e) {
            return API.Left((Object)new Error.FormatError.SerializationError(e.toString()));
        }
    }
}

