/*
 * Decompiled with CFR 0.152.
 */
package com.clevercloud.biscuit.token.builder;

import com.clevercloud.biscuit.error.Error;
import com.clevercloud.biscuit.token.builder.Check;
import com.clevercloud.biscuit.token.builder.Expression;
import com.clevercloud.biscuit.token.builder.Fact;
import com.clevercloud.biscuit.token.builder.Predicate;
import com.clevercloud.biscuit.token.builder.Rule;
import com.clevercloud.biscuit.token.builder.Term;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class Utils {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static Fact fact(String name, List<Term> ids) throws Error.Language {
        return new Fact(name, ids);
    }

    public static Predicate pred(String name, List<Term> ids) {
        return new Predicate(name, ids);
    }

    public static Rule rule(String head_name, List<Term> head_ids, List<Predicate> predicates) {
        return new Rule(Utils.pred(head_name, head_ids), predicates, new ArrayList<Expression>());
    }

    public static Rule constrained_rule(String head_name, List<Term> head_ids, List<Predicate> predicates, List<Expression> expressions) {
        return new Rule(Utils.pred(head_name, head_ids), predicates, expressions);
    }

    public static Check check(Rule rule) {
        return new Check(rule);
    }

    public static Term integer(long i) {
        return new Term.Integer(i);
    }

    public static Term string(String s) {
        return new Term.Str(s);
    }

    public static Term s(String str) {
        return new Term.Str(str);
    }

    public static Term date(Date d) {
        return new Term.Date(d.getTime() / 1000L);
    }

    public static Term var(String name) {
        return new Term.Variable(name);
    }

    public static Term set(HashSet<Term> s) {
        return new Term.Set(s);
    }

    public static String byteArrayToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexStringToByteArray(String hex) {
        int l = hex.length();
        byte[] data = new byte[l / 2];
        for (int i = 0; i < l; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }
}

