/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.cli;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseCredentials;
import com.clickhouse.client.ClickHouseFile;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.cli.config.ClickHouseCommandLineOption;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClickHouseCommandLine
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseCommandLine.class);
    public static final String DEFAULT_CLI_ARG_VERSION = "--version";
    public static final String DEFAULT_CLICKHOUSE_CLI_PATH = "clickhouse";
    public static final String DEFAULT_CLIENT_OPTION = "client";
    public static final String DEFAULT_DOCKER_CLI_PATH = "docker";
    public static final String DEFAULT_DOCKER_IMAGE = "clickhouse/clickhouse-server";
    private final ClickHouseRequest<?> request;
    private final Process process;
    private String error;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean check(int timeout, String command, String ... args) {
        if (ClickHouseChecker.isNullOrBlank((CharSequence)command) || args == null) {
            throw new IllegalArgumentException("Non-blank command and non-null arguments are required");
        }
        ArrayList<String> list = new ArrayList<String>(args.length + 1);
        list.add(command);
        Collections.addAll(list, args);
        Process process = null;
        try {
            process = new ProcessBuilder(list).start();
            process.getOutputStream().close();
            if (process.waitFor(timeout, TimeUnit.MILLISECONDS)) {
                int exitValue = process.exitValue();
                if (exitValue != 0) {
                    log.trace((Object)"Command %s exited with value %d", new Object[]{list, exitValue});
                }
                boolean bl = exitValue == 0;
                return bl;
            }
            log.trace((Object)"Timed out after waiting %d ms for command %s to complete", new Object[]{timeout, list});
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.trace((Object)"Failed to check command %s due to: %s", new Object[]{list, e.getMessage()});
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroyForcibly();
            }
            process = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void dockerCommand(ClickHouseConfig config, String hostDir, String containerDir, int timeout, List<String> commands) {
        String str;
        String cli = (String)((Object)config.getOption((ClickHouseOption)ClickHouseCommandLineOption.DOCKER_CLI_PATH));
        if (ClickHouseChecker.isNullOrBlank((CharSequence)cli)) {
            cli = DEFAULT_DOCKER_CLI_PATH;
        }
        if (!ClickHouseCommandLine.check(timeout, cli, DEFAULT_CLI_ARG_VERSION)) {
            throw new UncheckedIOException(new ConnectException("Docker command-line is not available: " + cli));
        }
        commands.add(cli);
        String img = (String)((Object)config.getOption((ClickHouseOption)ClickHouseCommandLineOption.CLICKHOUSE_DOCKER_IMAGE));
        if (ClickHouseChecker.isNullOrBlank((CharSequence)img)) {
            img = DEFAULT_DOCKER_IMAGE;
        }
        if (!ClickHouseChecker.isNullOrBlank((CharSequence)(str = (String)((Object)config.getOption((ClickHouseOption)ClickHouseCommandLineOption.CLI_CONTAINER_ID))))) {
            if (!ClickHouseCommandLine.check(timeout, cli, "exec", str, DEFAULT_CLICKHOUSE_CLI_PATH, DEFAULT_CLIENT_OPTION, DEFAULT_CLI_ARG_VERSION)) {
                Class<ClickHouseCommandLine> clazz = ClickHouseCommandLine.class;
                // MONITORENTER : com.clickhouse.client.cli.ClickHouseCommandLine.class
                if (!ClickHouseCommandLine.check(timeout, cli, "exec", str, DEFAULT_CLICKHOUSE_CLI_PATH, DEFAULT_CLIENT_OPTION, DEFAULT_CLI_ARG_VERSION) && !ClickHouseCommandLine.check(timeout, cli, "run", "--rm", "--name", str, "-v", hostDir + ':' + containerDir, "-d", img, "tail", "-f", "/dev/null")) {
                    throw new UncheckedIOException(new ConnectException("Failed to start new container: " + str));
                }
                // MONITOREXIT : clazz
            }
            commands.add("exec");
            commands.add("-i");
            commands.add(str);
        } else {
            if (!ClickHouseCommandLine.check(timeout, cli, "run", "--rm", img, DEFAULT_CLICKHOUSE_CLI_PATH, DEFAULT_CLIENT_OPTION, DEFAULT_CLI_ARG_VERSION)) {
                throw new UncheckedIOException(new ConnectException("Invalid ClickHouse docker image: " + img));
            }
            commands.add("run");
            commands.add("--rm");
            commands.add("-i");
            commands.add("-v");
            commands.add(hostDir + ':' + containerDir);
            commands.add(img);
        }
        commands.add(DEFAULT_CLICKHOUSE_CLI_PATH);
    }

    static Process startProcess(ClickHouseRequest<?> request) {
        ClickHouseOutputStream chOutput;
        ClickHouseFile outputFile;
        Path p;
        long maxRows;
        ClickHouseConfig config = request.getConfig();
        ClickHouseNode server = request.getServer();
        int timeout = config.getSocketTimeout();
        String hostDir = (String)((Object)config.getOption((ClickHouseOption)ClickHouseCommandLineOption.CLI_WORK_DIRECTORY));
        hostDir = ClickHouseUtils.normalizeDirectory((String)(ClickHouseChecker.isNullOrBlank((CharSequence)hostDir) ? System.getProperty("java.io.tmpdir") : hostDir));
        String containerDir = (String)((Object)config.getOption((ClickHouseOption)ClickHouseCommandLineOption.CLI_CONTAINER_DIRECTORY));
        containerDir = ClickHouseChecker.isNullOrBlank((CharSequence)containerDir) ? "/tmp/" : ClickHouseUtils.normalizeDirectory((String)containerDir);
        LinkedList<String> commands = new LinkedList<String>();
        String cli = (String)((Object)config.getOption((ClickHouseOption)ClickHouseCommandLineOption.CLICKHOUSE_CLI_PATH));
        if (ClickHouseChecker.isNullOrBlank((CharSequence)cli)) {
            cli = DEFAULT_CLICKHOUSE_CLI_PATH;
        }
        if (!ClickHouseCommandLine.check(timeout, cli, DEFAULT_CLIENT_OPTION, DEFAULT_CLI_ARG_VERSION)) {
            ClickHouseCommandLine.dockerCommand(config, hostDir, containerDir, timeout, commands);
        } else {
            commands.add(cli);
            containerDir = hostDir;
        }
        commands.add(DEFAULT_CLIENT_OPTION);
        if (config.isSsl()) {
            commands.add("--secure");
        }
        commands.add("--compression=".concat(config.isResponseCompressed() ? "1" : "0"));
        commands.add("--host=".concat(server.getHost()));
        commands.add("--port=".concat(Integer.toString(server.getPort())));
        String str = server.getDatabase(config);
        if (!ClickHouseChecker.isNullOrBlank((CharSequence)str)) {
            commands.add("--database=".concat(str));
        }
        str = (String)((Object)config.getOption((ClickHouseOption)ClickHouseCommandLineOption.CLI_CONFIG_FILE));
        if (((Boolean)config.getOption((ClickHouseOption)ClickHouseCommandLineOption.USE_CLI_CONFIG)).booleanValue() && !ClickHouseChecker.isNullOrBlank((CharSequence)str) && Files.exists(Paths.get(str, new String[0]), new LinkOption[0])) {
            commands.add("--config-file=".concat(str));
        } else {
            ClickHouseCredentials credentials = server.getCredentials(config);
            str = credentials.getUserName();
            if (!ClickHouseChecker.isNullOrBlank((CharSequence)str)) {
                commands.add("--user=".concat(str));
            }
            if (!ClickHouseChecker.isNullOrBlank((CharSequence)(str = credentials.getPassword()))) {
                commands.add("--password=".concat(str));
            }
        }
        commands.add("--format=".concat(config.getFormat().name()));
        str = request.getQueryId().orElse("");
        if (!ClickHouseChecker.isNullOrBlank((CharSequence)str)) {
            commands.add("--query_id=".concat(str));
        }
        str = (String)request.getStatements(false).get(0);
        commands.add("--query=".concat(str));
        for (ClickHouseExternalTable table : request.getExternalTables()) {
            String filePath;
            ClickHouseFile tableFile = table.getFile();
            commands.add("--external");
            if (!tableFile.isAvailable() || !tableFile.getFile().getAbsolutePath().startsWith(hostDir)) {
                File f = ClickHouseInputStream.save((File)Paths.get(hostDir, "chc_".concat(UUID.randomUUID().toString())).toFile(), (InputStream)table.getContent(), (int)config.getWriteBufferSize(), (int)config.getSocketTimeout(), (boolean)true);
                filePath = containerDir.concat(f.getName());
            } else {
                filePath = tableFile.getFile().getAbsolutePath();
                if (!hostDir.equals(containerDir)) {
                    filePath = Paths.get(containerDir, filePath.substring(hostDir.length())).toFile().getAbsolutePath();
                }
            }
            commands.add("--file=" + filePath);
            if (!ClickHouseChecker.isNullOrEmpty((CharSequence)table.getName())) {
                commands.add("--name=".concat(table.getName()));
            }
            if (table.getFormat() != null) {
                commands.add("--format=".concat(table.getFormat().name()));
            }
            commands.add("--structure=".concat(table.getStructure()));
        }
        Map settings = request.getSettings();
        Object value = settings.get("max_result_rows");
        if (value instanceof Number && (maxRows = ((Number)value).longValue()) > 0L) {
            commands.add("--limit=".concat(Long.toString(maxRows)));
        }
        if ((value = settings.get("result_overflow_mode")) != null) {
            commands.add("--result_overflow_mode=".concat(value.toString()));
        }
        if ((value = settings.get("readonly")) != null) {
            commands.add("--readonly=".concat(value.toString()));
        }
        if (((Boolean)config.getOption((ClickHouseOption)ClickHouseCommandLineOption.USE_PROFILE_EVENTS)).booleanValue()) {
            commands.add("--print-profile-events");
            commands.add("--profile-events-delay-ms=-1");
        }
        log.debug((Object)"Query: %s", new Object[]{str});
        ProcessBuilder builder = new ProcessBuilder(commands);
        String workDirectory = (String)((Object)config.getOption((ClickHouseOption)ClickHouseCommandLineOption.CLI_WORK_DIRECTORY));
        if (!ClickHouseChecker.isNullOrBlank((CharSequence)workDirectory) && Files.isDirectory(p = Paths.get(workDirectory, new String[0]), new LinkOption[0])) {
            builder.directory(p.toFile());
        }
        if (request.hasOutputStream() && (outputFile = (chOutput = (ClickHouseOutputStream)request.getOutputStream().get()).getUnderlyingFile()).isAvailable()) {
            File f = outputFile.getFile();
            if (hostDir.equals(containerDir)) {
                builder.redirectOutput(f);
            } else if (f.getAbsolutePath().startsWith(hostDir)) {
                String relativePath = f.getAbsolutePath().substring(hostDir.length());
                builder.redirectOutput(new File(containerDir.concat(relativePath)));
            } else {
                String fileName = f.getName();
                int len = fileName.length();
                int index = fileName.indexOf(46, 1);
                String uuid = UUID.randomUUID().toString();
                fileName = index > 0 && index + 1 < len ? new StringBuilder(len + uuid.length() + 1).append(fileName.substring(0, index)).append('_').append(uuid).append(fileName.substring(index)).toString() : new StringBuilder(len + uuid.length() + 1).append(fileName).append('_').append(UUID.randomUUID().toString()).toString();
                Path newPath = Paths.get(hostDir, fileName);
                try {
                    f = Files.createLink(newPath, f.toPath()).toFile();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (UnsupportedOperationException e) {
                    try {
                        f = ClickHouseInputStream.save((File)newPath.toFile(), (InputStream)new FileInputStream(f), (int)config.getWriteBufferSize(), (int)timeout, (boolean)true);
                    }
                    catch (FileNotFoundException exp) {
                        throw new UncheckedIOException(exp);
                    }
                }
            }
            builder.redirectOutput(f);
        }
        Optional in = request.getInputStream();
        try {
            Process process;
            if (in.isPresent()) {
                File inputFile;
                ClickHouseInputStream chInput = (ClickHouseInputStream)in.get();
                if (chInput.getUnderlyingFile().isAvailable()) {
                    inputFile = chInput.getUnderlyingFile().getFile();
                } else {
                    CompletableFuture data = ClickHouseClient.submit(() -> {
                        File tmp = File.createTempFile("tmp", "data");
                        tmp.deleteOnExit();
                        try (ClickHouseOutputStream out = ClickHouseOutputStream.of((OutputStream)new FileOutputStream(tmp));){
                            ((ClickHouseInputStream)request.getInputStream().get()).pipe(out);
                        }
                        return tmp;
                    });
                    inputFile = (File)data.get(timeout, TimeUnit.MILLISECONDS);
                }
                process = builder.redirectInput(inputFile).start();
            } else {
                process = builder.start();
                process.getOutputStream().close();
            }
            return process;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CompletionException(e);
        }
        catch (CancellationException | ExecutionException | TimeoutException e) {
            throw new CompletionException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ClickHouseCommandLine(ClickHouseRequest<?> request) {
        this.request = request;
        this.process = ClickHouseCommandLine.startProcess(request);
        this.error = null;
    }

    public ClickHouseInputStream getInputStream() throws IOException {
        ClickHouseOutputStream out = this.request.getOutputStream().orElse(null);
        Runnable postCloseAction = () -> {
            IOException exp = this.getError();
            if (exp != null) {
                throw new UncheckedIOException(exp);
            }
        };
        if (out != null && !out.getUnderlyingFile().isAvailable()) {
            try (ClickHouseOutputStream o = out;){
                ClickHouseInputStream.pipe((InputStream)this.process.getInputStream(), (OutputStream)o, (int)this.request.getConfig().getWriteBufferSize());
            }
            return ClickHouseInputStream.wrap(null, (InputStream)ClickHouseInputStream.empty(), (int)this.request.getConfig().getReadBufferSize(), (Runnable)postCloseAction, (ClickHouseCompression)ClickHouseCompression.NONE, (int)0);
        }
        return ClickHouseInputStream.of((InputStream)this.process.getInputStream(), (int)this.request.getConfig().getReadBufferSize(), (Runnable)postCloseAction);
    }

    IOException getError() {
        if (this.error == null) {
            int bufferSize = (Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue();
            try (ByteArrayOutputStream output = new ByteArrayOutputStream(bufferSize);){
                ClickHouseInputStream.pipe((InputStream)this.process.getErrorStream(), (OutputStream)output, (int)bufferSize);
                this.error = new String(output.toByteArray(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                this.error = "";
            }
            try {
                int exitValue = this.process.waitFor();
                if (exitValue != 0) {
                    int index;
                    this.error = this.error.isEmpty() ? ClickHouseUtils.format((String)"Command exited with value %d", (Object[])new Object[]{exitValue}) : ((index = this.error.trim().indexOf(10)) > 0 ? this.error.substring(index + 1) : this.error);
                } else {
                    if (!this.error.isEmpty()) {
                        log.trace(() -> {
                            for (String line : this.error.split("\n")) {
                                log.trace((Object)line, new Object[0]);
                            }
                            return "";
                        });
                    }
                    this.error = "";
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.process.destroyForcibly();
                throw new CompletionException(e);
            }
        }
        return !ClickHouseChecker.isNullOrBlank((CharSequence)this.error) ? new IOException(this.error) : null;
    }

    @Override
    public void close() {
        if (this.process.isAlive()) {
            this.process.destroyForcibly();
        }
    }
}

