/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.cli.config;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.config.ClickHouseOption;
import java.io.Serializable;

public enum ClickHouseCommandLineOption implements ClickHouseOption
{
    CLICKHOUSE_CLI_PATH("clickhouse_cli_path", "", "ClickHouse native command-line client path, empty value is treated as 'clickhouse'"),
    CLICKHOUSE_DOCKER_IMAGE("clickhouse_docker_image", "clickhouse/clickhouse-server", "ClickHouse docker image, empty value is treated as 'clickhouse/clickhouse-server'"),
    DOCKER_CLI_PATH("docker_cli_path", "", "Docker command-line path, empty value is treated as 'docker'"),
    CLI_CONFIG_FILE("cli_config_file", "~/.clickhouse-client/config.xml", "ClickHouse native command-line client configuration file, empty value will disable 'use_cli_config'"),
    CLI_CONTAINER_ID("cli_container_id", "clickhouse-cli-client", "Docker container ID or name, empty value will result in new container being created for each query"),
    CLI_CONTAINER_DIRECTORY("cli_container_directory", "", "Work directory inside container, empty value is treated as '/tmp'"),
    CLI_WORK_DIRECTORY("cli_work_directory", "", "Command-line work directory, empty value is treate as system temporary directory"),
    USE_CLI_CONFIG("use_cli_config", false, "Whether to use native command-line client configuration file as defined in 'cli_config_file'"),
    USE_PROFILE_EVENTS("use_profile_events", false, "Whether to use profile events or not");

    private final String key;
    private final Serializable defaultValue;
    private final Class<? extends Serializable> clazz;
    private final String description;

    private <T extends Serializable> ClickHouseCommandLineOption(String key, T defaultValue, String description) {
        this.key = (String)ClickHouseChecker.nonNull((Object)key, (String)"key");
        this.defaultValue = (Serializable)ClickHouseChecker.nonNull(defaultValue, (String)"defaultValue");
        this.clazz = defaultValue.getClass();
        this.description = (String)ClickHouseChecker.nonNull((Object)description, (String)"description");
    }

    public Serializable getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKey() {
        return this.key;
    }

    public Class<? extends Serializable> getValueType() {
        return this.clazz;
    }
}

