/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.config.ClickHouseClientOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.file.Path;

public class ClickHouseFile {
    public static final ClickHouseFile NULL = new ClickHouseFile(null, ClickHouseCompression.NONE, 0, null);
    private final File file;
    private final ClickHouseCompression compress;
    private final int compressLevel;
    private final ClickHouseFormat format;

    public static ClickHouseFile of(File file) {
        return ClickHouseFile.of(file, null, 0, null);
    }

    public static ClickHouseFile of(Path path) {
        return ClickHouseFile.of(ClickHouseChecker.nonNull(path, "Path").toFile(), null, 0, null);
    }

    public static ClickHouseFile of(String file) {
        return ClickHouseFile.of(new File(ClickHouseChecker.nonEmpty(file, "File")), null, 0, null);
    }

    public static ClickHouseFile of(String file, ClickHouseCompression compression, int compressionLevel, ClickHouseFormat format) {
        return ClickHouseFile.of(new File(ClickHouseChecker.nonEmpty(file, "File")), compression, compressionLevel, format);
    }

    public static ClickHouseFile of(File file, ClickHouseCompression compression, int compressionLevel, ClickHouseFormat format) {
        return new ClickHouseFile(ClickHouseChecker.nonNull(file, "File"), compression != null ? compression : ClickHouseCompression.fromFileName(file.getName()), compressionLevel < 1 ? 0 : compressionLevel, format != null ? format : ClickHouseFormat.fromFileName(file.getName()));
    }

    protected ClickHouseFile(File file, ClickHouseCompression compress, int compressLevel, ClickHouseFormat format) {
        this.file = file;
        this.compress = compress;
        this.compressLevel = compressLevel;
        this.format = format;
    }

    public ClickHouseInputStream asInputStream() {
        if (!this.isAvailable()) {
            return ClickHouseInputStream.empty();
        }
        try {
            return ClickHouseInputStream.wrap(this, new FileInputStream(this.getFile()), (Integer)ClickHouseClientOption.READ_BUFFER_SIZE.getDefaultValue(), null, this.getCompressionAlgorithm(), this.getCompressionLevel());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public ClickHouseOutputStream asOutputStream() {
        if (!this.isAvailable()) {
            return ClickHouseOutputStream.empty();
        }
        try {
            return ClickHouseOutputStream.wrap(this, new FileOutputStream(this.getFile()), (Integer)ClickHouseClientOption.WRITE_BUFFER_SIZE.getDefaultValue(), null, this.getCompressionAlgorithm(), this.getCompressionLevel());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public ClickHouseFormat getFormat() {
        return this.format;
    }

    public ClickHouseCompression getCompressionAlgorithm() {
        return this.compress;
    }

    public int getCompressionLevel() {
        return this.compressLevel;
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public boolean isAvailable() {
        return this.file != null && this.file.exists();
    }

    public boolean isCompressed() {
        return this.compress != ClickHouseCompression.NONE;
    }
}

