/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class ClickHouseDateValue
extends ClickHouseObjectValue<LocalDate> {
    public static ClickHouseDateValue ofNull() {
        return ClickHouseDateValue.ofNull(null);
    }

    public static ClickHouseDateValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseDateValue ? (ClickHouseDateValue)((ClickHouseDateValue)ref).set(null) : new ClickHouseDateValue(null);
    }

    public static ClickHouseDateValue of(LocalDate value) {
        return ClickHouseDateValue.of(null, value);
    }

    public static ClickHouseDateValue of(long epochDay) {
        return ClickHouseDateValue.of(null, LocalDate.ofEpochDay(epochDay));
    }

    public static ClickHouseDateValue of(ClickHouseValue ref, LocalDate value) {
        return ref instanceof ClickHouseDateValue ? ((ClickHouseDateValue)ref).update(value) : new ClickHouseDateValue(value);
    }

    protected ClickHouseDateValue(LocalDate value) {
        super(value);
    }

    @Override
    public ClickHouseDateValue copy(boolean deep) {
        return new ClickHouseDateValue((LocalDate)this.getValue());
    }

    @Override
    public byte asByte() {
        return (byte)this.asLong();
    }

    @Override
    public short asShort() {
        return (short)this.asLong();
    }

    @Override
    public int asInteger() {
        return (int)this.asLong();
    }

    @Override
    public long asLong() {
        return this.isNullOrEmpty() ? 0L : ((LocalDate)this.getValue()).toEpochDay();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNullOrEmpty() ? null : BigInteger.valueOf(((LocalDate)this.getValue()).toEpochDay());
    }

    @Override
    public float asFloat() {
        return this.asLong();
    }

    @Override
    public double asDouble() {
        return this.asLong();
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNullOrEmpty() ? null : new BigDecimal(this.asBigInteger(), scale);
    }

    @Override
    public LocalDate asDate() {
        return (LocalDate)this.getValue();
    }

    @Override
    public final LocalTime asTime(int scale) {
        return this.isNullOrEmpty() ? null : LocalTime.ofSecondOfDay(0L);
    }

    @Override
    public LocalDateTime asDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return LocalDateTime.of((LocalDate)this.getValue(), ClickHouseValues.TIME_ZERO);
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        String str = this.asDate().format(ClickHouseValues.DATE_FORMATTER);
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        return '\'' + this.asDate().format(ClickHouseValues.DATE_FORMATTER) + '\'';
    }

    @Override
    public ClickHouseDateValue update(byte value) {
        this.set(LocalDate.ofEpochDay(value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(short value) {
        this.set(LocalDate.ofEpochDay(value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(int value) {
        this.set(LocalDate.ofEpochDay(value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(long value) {
        this.set(LocalDate.ofEpochDay(value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(float value) {
        this.set(LocalDate.ofEpochDay((long)value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(double value) {
        this.set(LocalDate.ofEpochDay((long)value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(BigInteger value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDate.ofEpochDay(value.longValueExact()));
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(BigDecimal value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDate.ofEpochDay(value.longValueExact()));
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(Enum<?> value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDate.ofEpochDay(value.ordinal()));
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(LocalDate value) {
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseDateValue update(LocalTime value) {
        return this;
    }

    @Override
    public ClickHouseDateValue update(LocalDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.toLocalDate());
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(String value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDate.parse(value, ClickHouseValues.DATE_FORMATTER));
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.asDate());
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(Object value) {
        if (value instanceof LocalDate) {
            this.set((LocalDate)value);
        } else if (value instanceof LocalDateTime) {
            this.set(((LocalDateTime)value).toLocalDate());
        } else if (value instanceof LocalTime) {
            this.set(LocalDate.now());
        } else {
            super.update(value);
        }
        return this;
    }
}

