/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseDataUpdater;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class ClickHousePipedStream
extends ClickHouseOutputStream {
    protected final BlockingQueue<ByteBuffer> queue;
    private final int bufferSize;
    private final int timeout;
    private ByteBuffer buffer;

    public ClickHousePipedStream(int bufferSize, int queueLength, int timeout) {
        super(null);
        this.queue = queueLength <= 0 ? new LinkedBlockingDeque() : new ArrayBlockingQueue(queueLength);
        this.bufferSize = ClickHouseUtils.getBufferSize(bufferSize, (Integer)ClickHouseClientOption.WRITE_BUFFER_SIZE.getDefaultValue(), (Integer)ClickHouseClientOption.MAX_BUFFER_SIZE.getDefaultValue());
        this.timeout = timeout;
        this.buffer = ByteBuffer.allocate(this.bufferSize);
    }

    private void updateBuffer() throws IOException {
        if (this.buffer.hasRemaining()) {
            ((Buffer)this.buffer).limit(this.buffer.position());
        }
        ((Buffer)this.buffer).rewind();
        try {
            if (this.timeout > 0) {
                if (!this.queue.offer(this.buffer, this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new IOException(ClickHouseUtils.format("Write timed out after %d ms", this.timeout));
                }
            } else {
                this.queue.put(this.buffer);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when putting buffer into queue", e);
        }
        this.buffer = ByteBuffer.allocate(this.bufferSize);
    }

    public ClickHouseInputStream getInput() {
        return ClickHouseInputStream.of(this.queue, this.timeout);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.buffer = ClickHouseByteBuffer.EMPTY_BUFFER;
        try {
            if (this.timeout > 0) {
                if (!this.queue.offer(this.buffer, this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new IOException(ClickHouseUtils.format("Close stream timed out after %d ms", this.timeout));
                }
            } else {
                this.queue.put(this.buffer);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when putting EMPTY buffer into queue", e);
        }
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (this.buffer.position() > 0) {
            this.updateBuffer();
        }
    }

    @Override
    public ClickHouseOutputStream writeByte(byte b) throws IOException {
        this.ensureOpen();
        this.buffer.put(b);
        if (!this.buffer.hasRemaining()) {
            this.updateBuffer();
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return this;
        }
        this.ensureOpen();
        while (length > 0) {
            int remain = this.buffer.remaining();
            if (length < remain) {
                this.buffer.put(bytes, offset, length);
                length = 0;
                continue;
            }
            this.buffer.put(bytes, offset, remain);
            offset += remain;
            length -= remain;
            this.updateBuffer();
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeCustom(ClickHouseDataUpdater writer) throws IOException {
        this.ensureOpen();
        int position = 0;
        int written = 0;
        do {
            byte[] bytes;
            position = this.buffer.position();
            int limit = this.buffer.limit();
            if (this.buffer.hasArray()) {
                bytes = this.buffer.array();
            } else {
                bytes = new byte[limit - position];
                this.buffer.get(bytes);
            }
            written = writer.update(bytes, position, limit);
            if (written >= 0) continue;
            ((Buffer)this.buffer).position(limit);
            this.updateBuffer();
        } while (written < 0);
        ((Buffer)this.buffer).position(position + written);
        return this;
    }
}

