/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class ClickHouseInputStream
extends InputStream {
    public static ClickHouseInputStream of(InputStream input) {
        return input instanceof ClickHouseInputStream ? (ClickHouseInputStream)input : new SimpleInputStream(input);
    }

    public int readUnsignedByte() throws IOException {
        return 0xFF & this.readByte();
    }

    public abstract byte readByte() throws IOException;

    public abstract boolean isClosed();

    static final class SimpleInputStream
    extends ClickHouseInputStream {
        private final InputStream in;
        private boolean closed;

        protected SimpleInputStream(InputStream input) {
            this.in = ClickHouseChecker.nonNull(input, "InputStream");
            this.closed = false;
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public byte readByte() throws IOException {
            int v = this.in.read();
            if (v == -1) {
                this.close();
                throw new EOFException();
            }
            return (byte)v;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
            this.closed = true;
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }
    }
}

