/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ClickHouseEnumValue<T extends Enum<T>>
extends ClickHouseObjectValue<T> {
    static final String ERROR_NO_ENUM_TYPE = "Failed to convert value due to lack of enum type: ";

    public static <T extends Enum<T>> ClickHouseEnumValue<T> ofNull() {
        return ClickHouseEnumValue.ofNull(null);
    }

    public static <T extends Enum<T>> ClickHouseEnumValue<T> ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseEnumValue ? (ClickHouseEnumValue)((ClickHouseEnumValue)ref).set(null) : new ClickHouseEnumValue(null);
    }

    public static <T extends Enum<T>> ClickHouseEnumValue<T> of(T value) {
        return ClickHouseEnumValue.of(null, value);
    }

    public static <T extends Enum<T>> ClickHouseEnumValue<T> of(ClickHouseValue ref, T value) {
        return ref instanceof ClickHouseEnumValue ? ((ClickHouseEnumValue)ref).update((Enum)value) : new ClickHouseEnumValue<T>(value);
    }

    protected ClickHouseEnumValue(T value) {
        super(value);
    }

    @Override
    public ClickHouseEnumValue<T> copy(boolean deep) {
        return new ClickHouseEnumValue<Enum>((Enum)this.getValue());
    }

    @Override
    public byte asByte() {
        return this.isNullOrEmpty() ? (byte)0 : (byte)((Enum)this.getValue()).ordinal();
    }

    @Override
    public short asShort() {
        return this.isNullOrEmpty() ? (short)0 : (short)((Enum)this.getValue()).ordinal();
    }

    @Override
    public int asInteger() {
        return this.isNullOrEmpty() ? 0 : ((Enum)this.getValue()).ordinal();
    }

    @Override
    public long asLong() {
        return this.isNullOrEmpty() ? 0L : (long)((Enum)this.getValue()).ordinal();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNullOrEmpty() ? null : BigInteger.valueOf(((Enum)this.getValue()).ordinal());
    }

    @Override
    public float asFloat() {
        return this.isNullOrEmpty() ? 0.0f : (float)((Enum)this.getValue()).ordinal();
    }

    @Override
    public double asDouble() {
        return this.isNullOrEmpty() ? 0.0 : (double)((Enum)this.getValue()).ordinal();
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNullOrEmpty() ? null : BigDecimal.valueOf(((Enum)this.getValue()).ordinal(), scale);
    }

    public <E extends Enum<E>> E asEnum(Class<E> enumType) {
        return (E)((Enum)this.getValue());
    }

    @Override
    public Object asObject() {
        return this.getValue();
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        String str = String.valueOf(((Enum)this.getValue()).name());
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public String toSqlExpression() {
        return ClickHouseValues.convertToQuotedString(this.asString(0, null));
    }

    @Override
    public ClickHouseEnumValue<T> update(boolean value) {
        return this.update(value ? 1 : 0);
    }

    @Override
    public ClickHouseEnumValue<T> update(char value) {
        return this.update((int)value);
    }

    @Override
    public ClickHouseEnumValue<T> update(byte value) {
        return this.update((int)value);
    }

    @Override
    public ClickHouseEnumValue<T> update(short value) {
        return this.update((int)value);
    }

    @Override
    public ClickHouseEnumValue<T> update(int value) {
        if (this.isNullOrEmpty()) {
            throw new IllegalArgumentException(ERROR_NO_ENUM_TYPE + value);
        }
        Class<?> clazz = ((Enum)this.getValue()).getClass();
        for (Enum t : (Enum[])clazz.getEnumConstants()) {
            if (t.ordinal() != value) continue;
            return this.update(t);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ClickHouseEnumValue<T> update(long value) {
        return this.update((int)value);
    }

    @Override
    public ClickHouseEnumValue<T> update(float value) {
        return this.update((int)value);
    }

    @Override
    public ClickHouseEnumValue<T> update(double value) {
        return this.update((int)value);
    }

    @Override
    public ClickHouseEnumValue<T> update(BigInteger value) {
        if (value == null) {
            this.resetToNullOrEmpty();
            return this;
        }
        return this.update(value.intValueExact());
    }

    @Override
    public ClickHouseEnumValue<T> update(BigDecimal value) {
        if (value == null) {
            this.resetToNullOrEmpty();
            return this;
        }
        return this.update(value.intValueExact());
    }

    @Override
    public ClickHouseEnumValue<T> update(Enum<?> value) {
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseEnumValue<T> update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            this.resetToNullOrEmpty();
        } else if (value instanceof ClickHouseEnumValue) {
            this.set((Enum)((ClickHouseEnumValue)value).getValue());
        } else {
            if (this.isNullOrEmpty()) {
                throw new IllegalArgumentException(ERROR_NO_ENUM_TYPE + value);
            }
            this.set(value.asEnum(this.isNullOrEmpty() ? null : ((Enum)this.getValue()).getClass()));
        }
        return this;
    }

    @Override
    public ClickHouseEnumValue<T> update(String value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            if (this.isNullOrEmpty()) {
                throw new IllegalArgumentException(ERROR_NO_ENUM_TYPE + value);
            }
            this.set(Enum.valueOf(((Enum)this.getValue()).getClass(), value));
        }
        return this;
    }

    @Override
    public ClickHouseEnumValue<T> update(Object value) {
        if (value instanceof Enum) {
            this.set((Enum)value);
            return this;
        }
        if (value instanceof ClickHouseEnumValue) {
            this.set((Enum)((ClickHouseEnumValue)value).getValue());
            return this;
        }
        super.update(value);
        return this;
    }
}

