/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class ClickHousePipedStream
extends OutputStream {
    protected static final ByteBuffer EMPTY = ByteBuffer.wrap(new byte[0]);
    protected final BlockingQueue<ByteBuffer> queue;
    private final int bufferSize;
    private final int timeout;
    private ByteBuffer buffer;
    private boolean closed;

    public ClickHousePipedStream(int bufferSize, int queueLength, int timeout) {
        this.queue = queueLength <= 0 ? new LinkedBlockingDeque() : new ArrayBlockingQueue(queueLength);
        this.bufferSize = bufferSize <= 0 ? 8192 : bufferSize;
        this.timeout = timeout;
        this.buffer = ByteBuffer.allocate(this.bufferSize);
        this.closed = false;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream has been closed");
        }
    }

    private void updateBuffer() throws IOException {
        if (this.buffer.position() > 0) {
            if (this.buffer.hasRemaining()) {
                ((Buffer)this.buffer).limit(this.buffer.position());
            }
            ((Buffer)this.buffer).rewind();
            try {
                if (this.timeout > 0) {
                    if (!this.queue.offer(this.buffer, this.timeout, TimeUnit.MILLISECONDS)) {
                        throw new IOException(ClickHouseUtils.format("Write timed out after %d ms", this.timeout));
                    }
                } else {
                    this.queue.put(this.buffer);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread was interrupted when putting buffer into queue", e);
            }
            this.buffer = ByteBuffer.allocate(this.bufferSize);
        }
    }

    public ClickHouseInputStream getInput() {
        return new Input(this.queue, this.timeout);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.buffer = EMPTY;
        try {
            if (this.timeout > 0) {
                if (!this.queue.offer(this.buffer, this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new IOException(ClickHouseUtils.format("Close stream timed out after %d ms", this.timeout));
                }
            } else {
                this.queue.put(this.buffer);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when putting EMPTY buffer into queue", e);
        }
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        this.updateBuffer();
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        if (!this.buffer.hasRemaining()) {
            this.updateBuffer();
        }
        this.buffer.put((byte)(0xFF & b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        while (len > 0) {
            int remain = this.buffer.remaining();
            if (remain > 0) {
                if (remain >= len) {
                    this.buffer.put(b, off, len);
                    len = 0;
                    continue;
                }
                this.buffer.put(b, off, remain);
                off += remain;
                len -= remain;
                this.updateBuffer();
                continue;
            }
            this.updateBuffer();
        }
    }

    static class Input
    extends ClickHouseInputStream {
        private final BlockingQueue<ByteBuffer> queue;
        private final int timeout;
        private ByteBuffer buffer;
        private boolean closed;

        Input(BlockingQueue<ByteBuffer> queue, int timeout) {
            this.queue = queue;
            this.timeout = timeout;
            this.buffer = null;
            this.closed = false;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("Stream has been closed");
            }
            if (this.buffer == null) {
                this.updateBuffer();
            }
        }

        private int updateBuffer() throws IOException {
            try {
                if (this.timeout > 0) {
                    this.buffer = this.queue.poll(this.timeout, TimeUnit.MILLISECONDS);
                    if (this.buffer == null) {
                        throw new IOException(ClickHouseUtils.format("Read timed out after %d ms", this.timeout));
                    }
                } else {
                    this.buffer = this.queue.take();
                }
                return this.buffer.remaining();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread was interrupted when getting next buffer from queue", e);
            }
        }

        @Override
        public int available() throws IOException {
            this.ensureOpen();
            if (this.buffer == EMPTY || this.buffer.limit() == 0) {
                return 0;
            }
            int available = this.buffer.remaining();
            if (available == 0) {
                available = this.updateBuffer();
            }
            return available;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.buffer = null;
        }

        @Override
        public byte readByte() throws IOException {
            this.ensureOpen();
            if (this.buffer == EMPTY || this.buffer.limit() == 0) {
                this.close();
                throw new EOFException();
            }
            if (this.buffer.hasRemaining()) {
                return this.buffer.get();
            }
            this.updateBuffer();
            return this.readByte();
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            if (this.buffer == EMPTY || this.buffer.limit() == 0) {
                return -1;
            }
            if (this.buffer.hasRemaining()) {
                return 0xFF & this.buffer.get();
            }
            this.updateBuffer();
            return this.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            if (this.buffer == EMPTY || this.buffer.limit() == 0) {
                return -1;
            }
            int counter = 0;
            while (len > 0) {
                if (this.buffer == EMPTY || this.buffer.limit() == 0) {
                    return counter;
                }
                int remain = this.buffer.remaining();
                if (remain > 0) {
                    if (remain >= len) {
                        this.buffer.get(b, off, len);
                        counter += len;
                        len = 0;
                        continue;
                    }
                    this.buffer.get(b, off, remain);
                    counter += remain;
                    off += remain;
                    len -= remain;
                    this.updateBuffer();
                    continue;
                }
                this.updateBuffer();
            }
            return counter;
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureOpen();
            if (n == Long.MAX_VALUE) {
                long counter = this.buffer.remaining();
                while (this.buffer != EMPTY && this.buffer.limit() > 0) {
                    counter += (long)this.buffer.limit();
                    this.updateBuffer();
                }
                return counter;
            }
            return super.skip(n);
        }
    }
}

