/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.data.BinaryStreamUtils;
import com.clickhouse.client.data.ClickHouseBlockChecksum;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class ClickHouseLZ4InputStream
extends ClickHouseInputStream {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    static final int MAGIC = 130;
    private final InputStream stream;
    private ByteBuffer currentBlock;
    private boolean closed;

    private boolean checkNext() throws IOException {
        if (this.currentBlock == null || !this.currentBlock.hasRemaining()) {
            this.currentBlock = this.readNextBlock();
        }
        return this.currentBlock != null;
    }

    private ByteBuffer readNextBlock() throws IOException {
        int read = this.stream.read();
        if (read < 0) {
            return null;
        }
        byte[] bytes = new byte[16];
        bytes[0] = (byte)read;
        this.readFully(bytes, 1, 15);
        ClickHouseBlockChecksum expected = ClickHouseBlockChecksum.fromBytes(bytes);
        int magic = this.readUnsignedByteFromInput();
        if (magic != 130) {
            throw new IOException("Magic is not correct: " + magic);
        }
        this.readFully(bytes, 0, 8);
        int compressedSizeWithHeader = BinaryStreamUtils.toInt32(bytes, 0);
        int uncompressedSize = BinaryStreamUtils.toInt32(bytes, 4);
        int compressedSize = compressedSizeWithHeader - 9;
        byte[] block = new byte[compressedSize];
        this.readFully(block, 0, block.length);
        ClickHouseBlockChecksum real = ClickHouseBlockChecksum.calculateForBlock((byte)magic, compressedSizeWithHeader, uncompressedSize, block, compressedSize);
        if (!real.equals(expected)) {
            throw new IllegalArgumentException("Checksum doesn't match: corrupted data.");
        }
        byte[] decompressed = new byte[uncompressedSize];
        LZ4FastDecompressor decompressor = factory.fastDecompressor();
        decompressor.decompress(block, 0, decompressed, 0, uncompressedSize);
        return ByteBuffer.wrap(decompressed);
    }

    private void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.stream.read(b, off + n, len - n);
            if (count >= 0) continue;
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new EOFException();
        }
    }

    private int readUnsignedByteFromInput() throws IOException {
        int ch = this.stream.read();
        if (ch < 0) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new EOFException();
        }
        return ch;
    }

    public ClickHouseLZ4InputStream(InputStream stream) {
        this.stream = ClickHouseChecker.nonNull(stream, "InputStream");
        this.closed = false;
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.checkNext()) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new EOFException();
        }
        return this.currentBlock.get();
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        int estimated = this.stream.available();
        if (estimated == 0 && this.checkNext()) {
            estimated = this.currentBlock.remaining();
        }
        return estimated;
    }

    @Override
    public int read() throws IOException {
        return this.checkNext() ? 0xFF & this.currentBlock.get() : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int copied;
        int toCopy;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.checkNext()) {
            return -1;
        }
        for (copied = 0; copied != len; copied += toCopy) {
            toCopy = Math.min(this.currentBlock.remaining(), len - copied);
            this.currentBlock.get(b, off, toCopy);
            off += toCopy;
            if (this.checkNext()) continue;
            break;
        }
        return copied;
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String readString(int byteLength, Charset charset) throws IOException {
        if (byteLength < 1) {
            return "";
        }
        if (!this.checkNext()) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new EOFException();
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        if (byteLength > 8 && this.currentBlock.remaining() > byteLength) {
            int pos = this.currentBlock.position();
            ((Buffer)this.currentBlock).position(pos + byteLength);
            return charset.decode(ByteBuffer.wrap(this.currentBlock.array(), pos, byteLength)).toString();
        }
        return new String(this.readBytes(byteLength), charset);
    }
}

