/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class ClickHousePipedStream
extends OutputStream {
    protected final BlockingQueue<ByteBuffer> queue;
    private final int bufferSize;
    private final int timeout;
    private ByteBuffer buffer;
    private boolean closed;

    public ClickHousePipedStream(int bufferSize, int queueLength, int timeout) {
        this.queue = queueLength <= 0 ? new LinkedBlockingDeque() : new ArrayBlockingQueue(queueLength);
        this.bufferSize = bufferSize <= 0 ? 8192 : bufferSize;
        this.timeout = timeout;
        this.buffer = ByteBuffer.allocate(this.bufferSize);
        this.closed = false;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream has been closed");
        }
    }

    private void updateBuffer() throws IOException {
        if (this.buffer.position() > 0) {
            if (this.buffer.hasRemaining()) {
                ((Buffer)this.buffer).limit(this.buffer.position());
            }
            ((Buffer)this.buffer).rewind();
            try {
                if (this.timeout > 0) {
                    if (!this.queue.offer(this.buffer, this.timeout, TimeUnit.MILLISECONDS)) {
                        throw new IOException(ClickHouseUtils.format("Write timed out after %d ms", this.timeout));
                    }
                } else {
                    this.queue.put(this.buffer);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread was interrupted when putting buffer into queue", e);
            }
            this.buffer = ByteBuffer.allocate(this.bufferSize);
        }
    }

    public ClickHouseInputStream getInput() {
        return ClickHouseInputStream.of(this.queue, this.timeout);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.buffer = ClickHouseInputStream.EMPTY_BUFFER;
        try {
            if (this.timeout > 0) {
                if (!this.queue.offer(this.buffer, this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new IOException(ClickHouseUtils.format("Close stream timed out after %d ms", this.timeout));
                }
            } else {
                this.queue.put(this.buffer);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when putting EMPTY buffer into queue", e);
        }
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        this.updateBuffer();
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        if (!this.buffer.hasRemaining()) {
            this.updateBuffer();
        }
        this.buffer.put((byte)(0xFF & b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        while (len > 0) {
            int remain = this.buffer.remaining();
            if (remain > 0) {
                if (remain >= len) {
                    this.buffer.put(b, off, len);
                    len = 0;
                    continue;
                }
                this.buffer.put(b, off, remain);
                off += remain;
                len -= remain;
                this.updateBuffer();
                continue;
            }
            this.updateBuffer();
        }
    }
}

