/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.config;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.config.ClickHouseRenameMethod;
import com.clickhouse.client.config.ClickHouseSslMode;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ClickHouseClientOption implements ClickHouseOption
{
    ASYNC("async", true, "Whether the client should run in async mode."),
    BUFFER_SIZE("buffer_size", 8192, "Default buffer size in byte for both request and response."),
    BUFFER_QUEUE_VARIATION("buffer_queue_variation", 100, "Number of times the buffer queue is filled up before increasing capacity of buffer queue. Zero or negative value means the queue length is fixed."),
    READ_BUFFER_SIZE("read_buffer_size", 0, "Read buffer size in byte, zero or negative value means same as buffer_size"),
    WRITE_BUFFER_SIZE("write_buffer_size", 0, "Write buffer size in byte, zero or negative value means same as buffer_size"),
    REQUEST_CHUNK_SIZE("request_chunk_size", 0, "Maximum request chunk size in byte, zero or negative value means same as write_buffer_size"),
    REQUEST_BUFFERING("request_buffering", ClickHouseDefaults.BUFFERING.getDefaultValue(), "Request buffering mode"),
    RESPONSE_BUFFERING("response_buffering", ClickHouseDefaults.BUFFERING.getDefaultValue(), "Response buffering mode."),
    CLIENT_NAME("client_name", "ClickHouse Java Client", "Client name, which is either 'client_name' or 'http_user_agent' shows up in system.query_log table."),
    COMPRESS("compress", true, "Whether the server will compress response it sends to client."),
    DECOMPRESS("decompress", false, "Whether the server will decompress request from client."),
    COMPRESS_ALGORITHM("compress_alogrithm", ClickHouseCompression.LZ4, "Algorithm used for server to compress response."),
    DECOMPRESS_ALGORITHM("decompress_alogrithm", ClickHouseCompression.LZ4, "Algorithm for server to decompress request."),
    COMPRESS_LEVEL("compress_level", 3, "Compression level for response, from 0 to 9(low to high)"),
    DECOMPRESS_LEVEL("decompress_level", 3, "Compression level for request, from 0 to 9(low to high)"),
    CONNECTION_TIMEOUT("connect_timeout", 10000, "Connection timeout in milliseconds. It's also used for waiting a connection being closed."),
    DATABASE("database", "", "Default database."),
    FORMAT("format", ClickHouseFormat.TabSeparated, "Default format."),
    LOG_LEADING_COMMENT("log_leading_comment", false, "Whether to log leading comment(as log_comment in system.query_log) of the query."),
    MAX_BUFFER_SIZE("max_buffer_size", 0x40000000, "Maximum buffer size in byte can be used for streaming."),
    MAX_COMPRESS_BLOCK_SIZE("max_compress_block_size", 0x100000, "Maximum comression block size in byte."),
    MAX_EXECUTION_TIME("max_execution_time", 0, "Maximum query execution time in seconds, 0 means no limit."),
    MAX_QUEUED_BUFFERS("max_queued_buffers", 512, "Maximum queued in-memory buffers, 0 or negative number means no limit."),
    MAX_QUEUED_REQUESTS("max_queued_requests", 0, "Maximum queued requests, 0 or negative number means no limit."),
    MAX_RESULT_ROWS("max_result_rows", 0L, "Limit on the number of rows in the result.Also checked for subqueries, and on remote servers when running parts of a distributed query."),
    MAX_THREADS_PER_CLIENT("max_threads_per_client", 0, "Size of thread pool for each client instance, 0 or negative number means the client will use shared thread pool."),
    RENAME_RESPONSE_COLUMN("rename_response_column", ClickHouseRenameMethod.NONE, "Method to rename response columns."),
    RETRY("retry", true, "Whether to retry when there's connection issue."),
    REUSE_VALUE_WRAPPER("reuse_value_wrapper", true, "Whether to reuse wrapper of value(e.g. ClickHouseValue or ClickHouseRecord) for memory efficiency."),
    SERVER_TIME_ZONE("server_time_zone", "", "Server timezone."),
    SERVER_VERSION("server_version", "", "Server version."),
    SESSION_ID("session_id", "", "Session id"),
    SESSION_CHECK("session_check", false, "Whether to check if existence of session id."),
    SESSION_TIMEOUT("session_timeout", 0, "Session timeout in milliseconds. 0 or negative number means same as server default."),
    SOCKET_TIMEOUT("socket_timeout", 30000, "Socket timeout in milliseconds."),
    SSL("ssl", false, "Whether to enable SSL/TLS for the connection."),
    SSL_MODE("sslmode", ClickHouseSslMode.STRICT, "verify or not certificate: none (don't verify), strict (verify)"),
    SSL_ROOT_CERTIFICATE("sslrootcert", "", "SSL/TLS root certificates."),
    SSL_CERTIFICATE("sslcert", "", "SSL/TLS certificate."),
    SSL_KEY("sslkey", "", "RSA key in PKCS#8 format."),
    USE_BLOCKING_QUEUE("use_blocking_queue", true, "Whether to use blocking queue for buffering"),
    USE_OBJECTS_IN_ARRAYS("use_objects_in_arrays", false, "Whether Object[] should be used instead of primitive arrays."),
    USE_SERVER_TIME_ZONE("use_server_time_zone", true, "Whether to use server time zone. On connection init select timezone() will be executed"),
    USE_SERVER_TIME_ZONE_FOR_DATES("use_server_time_zone_for_dates", false, "Whether to use timezone from server on Date parsing in getDate(). If false, Date returned is a wrapper of a timestamp at start of the day in client timezone. If true - at start of the day in server or use_time_zone timezone."),
    USE_TIME_ZONE("use_time_zone", "", "Time zone of all DateTime* values. Only used when use_server_time_zone is false. Empty value means client time zone.");

    private final String key;
    private final Serializable defaultValue;
    private final Class<? extends Serializable> clazz;
    private final String description;
    private static final Map<String, ClickHouseClientOption> options;

    public static ClickHouseClientOption fromKey(String key) {
        return options.get(key);
    }

    private <T extends Serializable> ClickHouseClientOption(String key, T defaultValue, String description) {
        this.key = ClickHouseChecker.nonNull(key, "key");
        this.defaultValue = ClickHouseChecker.nonNull(defaultValue, "defaultValue");
        this.clazz = defaultValue.getClass();
        this.description = ClickHouseChecker.nonNull(description, "description");
    }

    @Override
    public Serializable getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Class<? extends Serializable> getValueType() {
        return this.clazz;
    }

    static {
        HashMap<String, ClickHouseClientOption> map = new HashMap<String, ClickHouseClientOption>();
        for (ClickHouseClientOption o : ClickHouseClientOption.values()) {
            if (map.put(o.getKey(), o) == null) continue;
            throw new IllegalStateException("Duplicated key found: " + o.getKey());
        }
        options = Collections.unmodifiableMap(map);
    }
}

