/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.domain;

public enum ClickHouseFormat {
    Arrow(true, true, true, true, false),
    ArrowStream(true, true, true, true, false),
    Avro(true, true, true, true, false),
    AvroConfluent(true, false, true, false, false),
    CapnProto(true, false, true, false, false),
    CSV(true, true, false, false, true),
    CSVWithNames(true, true, false, true, true),
    CustomSeparated(true, true, false, false, true),
    JSON(false, true, false, false, false),
    JSONAsString(true, false, false, false, false),
    JSONCompact(false, true, false, false, false),
    JSONCompactEachRow(true, true, false, false, true),
    JSONCompactEachRowWithNamesAndTypes(true, true, false, true, true),
    JSONCompactString(false, true, false, false, false),
    JSONCompactStringEachRow(true, true, false, false, true),
    JSONCompactStringEachRowWithNamesAndTypes(true, true, false, true, true),
    JSONEachRow(true, true, false, false, true),
    JSONEachRowWithProgress(false, true, false, false, true),
    JSONString(false, true, false, false, false),
    JSONStringsEachRow(true, true, false, false, true),
    JSONStringsEachRowWithProgress(false, true, false, false, true),
    LineAsString(true, false, false, false, true),
    Native(true, true, true, true, false),
    Null(false, true, false, false, false),
    ORC(true, false, true, true, false),
    Parquet(true, true, true, true, false),
    Pretty(false, true, false, false, false),
    PrettyCompact(false, true, false, false, false),
    PrettyCompactMonoBlock(false, true, false, false, false),
    PrettyNoEscapes(false, true, false, false, false),
    PrettySpace(false, true, false, false, false),
    Protobuf(true, true, true, true, false),
    ProtobufSingle(true, true, true, true, false),
    RawBLOB(true, true, true, false, false),
    Regexp(true, false, false, false, false),
    RowBinary(true, true, true, false, true),
    RowBinaryWithNamesAndTypes(true, true, true, true, true),
    TabSeparated(true, true, false, false, true),
    TabSeparatedRaw(true, true, false, false, true),
    TabSeparatedWithNames(true, true, false, true, true),
    TabSeparatedWithNamesAndTypes(true, true, false, true, true),
    TSV(true, true, false, false, true),
    TSVRaw(true, true, false, false, true),
    TSVWithNames(true, true, false, true, true),
    TSVWithNamesAndTypes(true, true, false, true, true),
    Template(true, true, false, true, true),
    TemplateIgnoreSpaces(true, false, false, true, true),
    TSKV(true, true, false, false, false),
    Values(true, true, false, false, true),
    Vertical(false, true, false, false, false),
    VerticalRaw(false, true, false, false, false),
    XML(false, true, false, false, false);

    private boolean input;
    private boolean output;
    private boolean binary;
    private boolean header;
    private boolean rowBased;

    private ClickHouseFormat(boolean input, boolean output, boolean binary, boolean header, boolean rowBased) {
        this.input = input;
        this.output = output;
        this.binary = binary;
        this.header = output && header;
        this.rowBased = rowBased;
    }

    public boolean supportsInput() {
        return this.input;
    }

    public boolean supportsOutput() {
        return this.output;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isText() {
        return !this.binary;
    }

    public boolean hasHeader() {
        return this.header;
    }

    public boolean isRowBased() {
        return this.rowBased;
    }

    public static boolean containsFormat(String statement) {
        if (statement == null || statement.isEmpty()) {
            return false;
        }
        String s = statement.replaceAll("[;\\s]", "");
        for (ClickHouseFormat f : ClickHouseFormat.values()) {
            if (!s.endsWith(f.name())) continue;
            return true;
        }
        return false;
    }
}

