/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseVersion;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.clickhouse.jdbc.SqlExceptionUtils;
import java.net.URI;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Optional;
import java.util.TimeZone;

public interface ClickHouseConnection
extends Connection {
    @Override
    default public ClickHouseStatement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    default public ClickHouseStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public ClickHouseStatement createStatement(int var1, int var2, int var3) throws SQLException;

    @Override
    default public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, 1);
    }

    @Override
    default public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    default public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("prepareCall not implemented");
    }

    @Override
    default public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    default public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2) {
            throw SqlExceptionUtils.unsupportedError("Only NO_GENERATED_KEYS is supported");
        }
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    default public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("ClickHouse does not support auto generated keys");
    }

    @Override
    default public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("ClickHouse does not support auto generated keys");
    }

    @Override
    default public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    public String getCurrentDatabase();

    public String getCurrentUser();

    public Calendar getDefaultCalendar();

    public Optional<TimeZone> getEffectiveTimeZone();

    public TimeZone getJvmTimeZone();

    public TimeZone getServerTimeZone();

    public ClickHouseVersion getServerVersion();

    public URI getUri();

    public boolean isJdbcCompliant();

    public String newQueryId();
}

