/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseDataType;

public final class JdbcTypeMapping {
    public static int toJdbcType(ClickHouseColumn column) {
        int sqlType = 1111;
        switch (column.getDataType()) {
            case Enum: 
            case Enum8: 
            case Int8: {
                sqlType = -6;
                break;
            }
            case UInt8: 
            case Enum16: 
            case Int16: {
                sqlType = 5;
                break;
            }
            case UInt16: 
            case Int32: {
                sqlType = 4;
                break;
            }
            case UInt32: 
            case IntervalYear: 
            case IntervalQuarter: 
            case IntervalMonth: 
            case IntervalWeek: 
            case IntervalDay: 
            case IntervalHour: 
            case IntervalMinute: 
            case IntervalSecond: 
            case Int64: {
                sqlType = -5;
                break;
            }
            case UInt64: 
            case Int128: 
            case UInt128: 
            case Int256: 
            case UInt256: {
                sqlType = 2;
                break;
            }
            case Float32: {
                sqlType = 6;
                break;
            }
            case Float64: {
                sqlType = 8;
                break;
            }
            case Decimal: 
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                sqlType = 3;
                break;
            }
            case Date: 
            case Date32: {
                sqlType = 91;
                break;
            }
            case DateTime: 
            case DateTime32: 
            case DateTime64: {
                sqlType = column.getTimeZone() != null ? 2014 : 93;
                break;
            }
            case IPv4: 
            case IPv6: 
            case FixedString: 
            case String: 
            case UUID: {
                sqlType = 12;
                break;
            }
            case Point: 
            case Ring: 
            case Polygon: 
            case MultiPolygon: 
            case Array: {
                sqlType = 2003;
                break;
            }
            case Nested: {
                sqlType = 2002;
                break;
            }
            case Nothing: {
                sqlType = 0;
                break;
            }
        }
        return sqlType;
    }

    public static ClickHouseColumn fromJdbcType(int jdbcType, int scaleOrLength) {
        ClickHouseDataType dataType = JdbcTypeMapping.fromJdbcType(jdbcType);
        ClickHouseColumn column = null;
        if (scaleOrLength > 0) {
            if (jdbcType == 2 || jdbcType == 3) {
                for (ClickHouseDataType t : new ClickHouseDataType[]{}) {
                    if (scaleOrLength > t.getMaxScale() / 2) continue;
                    column = ClickHouseColumn.of((String)"", (ClickHouseDataType)t, (boolean)false, (int)(t.getMaxPrecision() - t.getMaxScale()), (int)scaleOrLength);
                    break;
                }
            } else if (dataType == ClickHouseDataType.Date) {
                if (scaleOrLength > 2) {
                    dataType = ClickHouseDataType.Date32;
                }
            } else if (dataType == ClickHouseDataType.DateTime) {
                column = ClickHouseColumn.of((String)"", (ClickHouseDataType)ClickHouseDataType.DateTime64, (boolean)false, (int)0, (int)scaleOrLength);
            } else if (dataType == ClickHouseDataType.String) {
                column = ClickHouseColumn.of((String)"", (ClickHouseDataType)ClickHouseDataType.FixedString, (boolean)false, (int)scaleOrLength, (int)0);
            }
        }
        return column == null ? ClickHouseColumn.of((String)"", (ClickHouseDataType)dataType, (boolean)false, (boolean)false, (String[])new String[0]) : column;
    }

    public static ClickHouseDataType fromJdbcType(int jdbcType) {
        ClickHouseDataType dataType;
        switch (jdbcType) {
            case -7: 
            case 16: {
                dataType = ClickHouseDataType.UInt8;
                break;
            }
            case -6: {
                dataType = ClickHouseDataType.Int8;
                break;
            }
            case 5: {
                dataType = ClickHouseDataType.Int16;
                break;
            }
            case 4: {
                dataType = ClickHouseDataType.Int32;
                break;
            }
            case -5: {
                dataType = ClickHouseDataType.Int64;
                break;
            }
            case 2: {
                dataType = ClickHouseDataType.Int256;
                break;
            }
            case 6: 
            case 7: {
                dataType = ClickHouseDataType.Float32;
                break;
            }
            case 8: {
                dataType = ClickHouseDataType.Float64;
                break;
            }
            case 3: {
                dataType = ClickHouseDataType.Decimal;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 2000: 
            case 2004: 
            case 2005: 
            case 2009: 
            case 2011: {
                dataType = ClickHouseDataType.String;
                break;
            }
            case 91: {
                dataType = ClickHouseDataType.Date;
                break;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                dataType = ClickHouseDataType.DateTime;
                break;
            }
            case 2003: {
                dataType = ClickHouseDataType.Array;
                break;
            }
            case 2002: {
                dataType = ClickHouseDataType.Nested;
                break;
            }
            default: {
                dataType = ClickHouseDataType.Nothing;
            }
        }
        return dataType;
    }

    private JdbcTypeMapping() {
    }
}

