/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import java.sql.DriverPropertyInfo;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class JdbcConfig {
    public static final String PROP_AUTO_COMMIT = "autoCommit";
    public static final String PROP_FETCH_SIZE = "fetchSize";
    public static final String PROP_JDBC_COMPLIANT = "jdbcCompliant";
    public static final String PROP_NAMED_PARAM = "namedParameter";
    public static final String PROP_WRAPPER_OBJ = "wrapperObject";
    private static final String BOOLEAN_FALSE = "false";
    private static final String BOOLEAN_TRUE = "true";
    private static final String DEFAULT_AUTO_COMMIT = "true";
    private static final String DEFAULT_FETCH_SIZE = "0";
    private static final String DEFAULT_JDBC_COMPLIANT = "true";
    private static final String DEFAULT_NAMED_PARAM = "false";
    private static final String DEFAULT_WRAPPER_OBJ = "false";
    private final boolean autoCommit;
    private final int fetchSize;
    private final boolean jdbcCompliant;
    private final boolean namedParameter;
    private final boolean wrapperObject;

    static boolean extractBooleanValue(Properties props, String key, String defaultValue) {
        if (props == null || props.isEmpty() || key == null || key.isEmpty()) {
            return Boolean.parseBoolean(defaultValue);
        }
        Object value = props.remove(key);
        return Boolean.parseBoolean(value != null ? value.toString() : defaultValue);
    }

    static int extractIntValue(Properties props, String key, String defaultValue) {
        if (props == null || props.isEmpty() || key == null || key.isEmpty()) {
            return Integer.parseInt(defaultValue);
        }
        Object value = props.remove(key);
        return Integer.parseInt(value != null ? value.toString() : defaultValue);
    }

    public static List<DriverPropertyInfo> getDriverProperties() {
        LinkedList<DriverPropertyInfo> list = new LinkedList<DriverPropertyInfo>();
        DriverPropertyInfo info = new DriverPropertyInfo(PROP_AUTO_COMMIT, "true");
        info.choices = new String[]{"true", "false"};
        info.description = "Whether to enable auto commit when connection is created.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_FETCH_SIZE, DEFAULT_FETCH_SIZE);
        info.description = "Default fetch size, negative or zero means no preferred option.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_JDBC_COMPLIANT, "true");
        info.choices = new String[]{"true", "false"};
        info.description = "Whether to enable JDBC-compliant features like fake transaction and standard UPDATE and DELETE statements.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_NAMED_PARAM, "false");
        info.choices = new String[]{"true", "false"};
        info.description = "Whether to use named parameter(e.g. :ts(DateTime64(6)) or :value etc.) instead of standard JDBC question mark placeholder.";
        list.add(info);
        info = new DriverPropertyInfo(PROP_WRAPPER_OBJ, "false");
        info.choices = new String[]{"true", "false"};
        info.description = "Whether to return wrapper object like Array or Struct in ResultSet.getObject method.";
        list.add(info);
        return Collections.unmodifiableList(list);
    }

    public JdbcConfig() {
        this(null);
    }

    public JdbcConfig(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.autoCommit = JdbcConfig.extractBooleanValue(props, PROP_AUTO_COMMIT, "true");
        this.fetchSize = JdbcConfig.extractIntValue(props, PROP_FETCH_SIZE, DEFAULT_FETCH_SIZE);
        this.jdbcCompliant = JdbcConfig.extractBooleanValue(props, PROP_JDBC_COMPLIANT, "true");
        this.namedParameter = JdbcConfig.extractBooleanValue(props, PROP_NAMED_PARAM, "false");
        this.wrapperObject = JdbcConfig.extractBooleanValue(props, PROP_WRAPPER_OBJ, "false");
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean isJdbcCompliant() {
        return this.jdbcCompliant;
    }

    public boolean useNamedParameter() {
        return this.namedParameter;
    }

    public boolean useWrapperObject() {
        return this.wrapperObject;
    }
}

