/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseRequestManager;
import com.clickhouse.client.ClickHouseTransaction;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.JdbcSavepoint;
import com.clickhouse.logging.Logger;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JdbcTransaction {
    static final String ACTION_COMMITTED = "committed";
    static final String ACTION_ROLLBACK = "rolled back";
    static final String ERROR_TX_NOT_STARTED = "Transaction not started";
    protected final ClickHouseTransaction tx;
    protected final String id;
    protected final List<String> queries;
    protected final List<JdbcSavepoint> savepoints;

    JdbcTransaction() {
        this(null);
    }

    public JdbcTransaction(ClickHouseTransaction tx) {
        this.tx = tx;
        this.id = tx != null ? tx.getId().asTupleString() : ClickHouseRequestManager.getInstance().createUniqueId();
        this.queries = new LinkedList<String>();
        this.savepoints = new LinkedList<JdbcSavepoint>();
    }

    public void commit(Logger log) throws SQLException {
        if (this.tx != null) {
            try {
                this.tx.commit();
            }
            catch (ClickHouseException e) {
                throw SqlExceptionUtils.handle(e);
            }
        } else {
            this.logTransactionDetails(log, ACTION_COMMITTED);
        }
        this.clear();
    }

    public void rollback(Logger log) throws SQLException {
        if (this.tx != null) {
            try {
                this.tx.rollback();
            }
            catch (ClickHouseException e) {
                throw SqlExceptionUtils.handle(e);
            }
        } else {
            this.logTransactionDetails(log, ACTION_ROLLBACK);
        }
        this.clear();
    }

    synchronized List<String> getQueries() {
        return Collections.unmodifiableList(this.queries);
    }

    synchronized List<JdbcSavepoint> getSavepoints() {
        return Collections.unmodifiableList(this.savepoints);
    }

    synchronized void logSavepointDetails(Logger log, JdbcSavepoint s, String action) {
        log.warn((Object)"[JDBC Compliant Mode] Savepoint(id=%d, name=%s) of transaction [%s](%d queries & %d savepoints) is %s.", new Object[]{s.id, s.name, this.id, this.queries.size(), this.savepoints.size(), action});
    }

    synchronized void logTransactionDetails(Logger log, String action) {
        if (this.tx != null) {
            log.debug((Object)"%s (%d queries & %d savepoints) is %s", new Object[]{this.tx, this.queries.size(), this.savepoints.size(), action});
        } else {
            log.warn((Object)"[JDBC Compliant Mode] Transaction [%s] (%d queries & %d savepoints) is %s.", new Object[]{this.id, this.queries.size(), this.savepoints.size(), action});
        }
        if (log.isDebugEnabled()) {
            log.debug(() -> {
                log.debug((Object)"[JDBC Compliant Mode] Transaction [%s] is %s - begin", new Object[]{this.id, action});
                int total = this.queries.size();
                int counter = 1;
                for (String queryId : this.queries) {
                    log.debug((Object)"    '%s', -- query (%d of %d) in transaction [%s]", new Object[]{queryId, counter++, total, this.id});
                }
                total = this.savepoints.size();
                counter = 1;
                for (JdbcSavepoint savepoint : this.savepoints) {
                    log.debug((Object)"    %s (%d of %d) in transaction [%s]", new Object[]{savepoint, counter++, total, this.id});
                }
                return ClickHouseUtils.format((String)"[JDBC Compliant Mode] Transaction [%s] is %s - end", (Object[])new Object[]{this.id, action});
            });
        }
    }

    synchronized String newQuery(String queryId) {
        if (ClickHouseChecker.isNullOrEmpty((CharSequence)queryId) || this.queries.contains(queryId)) {
            queryId = ClickHouseRequestManager.getInstance().createQueryId();
        }
        this.queries.add(queryId);
        return queryId;
    }

    synchronized JdbcSavepoint newSavepoint(String name) {
        JdbcSavepoint savepoint = new JdbcSavepoint(this.queries.size(), name);
        this.savepoints.add(savepoint);
        return savepoint;
    }

    synchronized void toSavepoint(JdbcSavepoint savepoint) throws SQLException {
        if (this.tx != null) {
            try {
                this.tx.rollback();
            }
            catch (ClickHouseException e) {
                throw SqlExceptionUtils.handle(e);
            }
        }
        boolean found = false;
        Iterator<JdbcSavepoint> it = this.savepoints.iterator();
        while (it.hasNext()) {
            JdbcSavepoint s = it.next();
            if (found) {
                it.remove();
                continue;
            }
            if (s != savepoint) continue;
            found = true;
            it.remove();
        }
        if (!found) {
            throw SqlExceptionUtils.clientError("Invalid savepoint: " + savepoint);
        }
        this.queries.subList(savepoint.id, this.queries.size()).clear();
    }

    synchronized void clear() {
        this.queries.clear();
        this.savepoints.clear();
    }
}

