/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.UnsupportedProtocolException;
import com.clickhouse.client.grpc.ClickHouseGrpcClientImpl;
import com.clickhouse.client.grpc.config.ClickHouseGrpcOption;
import com.clickhouse.config.ClickHouseOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public class ClickHouseGrpcClient
implements ClickHouseClient {
    private final AtomicReference<ClickHouseClient> ref = new AtomicReference();

    protected ClickHouseClient getInstance() {
        ClickHouseClient instance = this.ref.get();
        if (instance == null) {
            try {
                instance = new ClickHouseGrpcClientImpl();
            }
            catch (ExceptionInInitializerError | NoClassDefFoundError e) {
                throw new UnsupportedProtocolException(ClickHouseProtocol.GRPC, "gRPC is not supported. Please use http protocol or add gRPC libraries to the classpath.");
            }
            if (!this.ref.compareAndSet(null, instance)) {
                instance.close();
                instance = this.ref.get();
            }
        }
        return instance;
    }

    @Override
    public final boolean accept(ClickHouseProtocol protocol) {
        return ClickHouseProtocol.GRPC == protocol || ClickHouseClient.super.accept(protocol);
    }

    @Override
    public final Class<? extends ClickHouseOption> getOptionClass() {
        return ClickHouseGrpcOption.class;
    }

    @Override
    public void init(ClickHouseConfig config) {
        this.getInstance().init(config);
    }

    @Override
    public boolean ping(ClickHouseNode server, int timeout) {
        return this.getInstance().ping(server, timeout);
    }

    @Override
    public CompletableFuture<ClickHouseResponse> execute(ClickHouseRequest<?> request) {
        return this.getInstance().execute(request);
    }

    @Override
    public ClickHouseConfig getConfig() {
        return this.getInstance().getConfig();
    }

    @Override
    public void close() {
        this.getInstance().close();
    }
}

