/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ClickHouseByteUtils {
    public static int getInt32LE(byte[] bytes, int offset) {
        return 0xFF & bytes[offset++] | (0xFF & bytes[offset++]) << 8 | (0xFF & bytes[offset++]) << 16 | (0xFF & bytes[offset]) << 24;
    }

    public static void setInt32LE(byte[] bytes, int offset, int value) {
        bytes[offset++] = (byte)(0xFF & value);
        bytes[offset++] = (byte)(0xFF & value >> 8);
        bytes[offset++] = (byte)(0xFF & value >> 16);
        bytes[offset] = (byte)(0xFF & value >> 24);
    }

    public static long getInt64LE(byte[] bytes, int offset) {
        return 0xFFL & (long)bytes[offset++] | (0xFFL & (long)bytes[offset++]) << 8 | (0xFFL & (long)bytes[offset++]) << 16 | (0xFFL & (long)bytes[offset++]) << 24 | (0xFFL & (long)bytes[offset++]) << 32 | (0xFFL & (long)bytes[offset++]) << 40 | (0xFFL & (long)bytes[offset++]) << 48 | (0xFFL & (long)bytes[offset]) << 56;
    }

    public static void setInt64LE(byte[] bytes, int offset, long value) {
        bytes[offset++] = (byte)(0xFFL & value);
        bytes[offset++] = (byte)(0xFFL & value >> 8);
        bytes[offset++] = (byte)(0xFFL & value >> 16);
        bytes[offset++] = (byte)(0xFFL & value >> 24);
        bytes[offset++] = (byte)(0xFFL & value >> 32);
        bytes[offset++] = (byte)(0xFFL & value >> 40);
        bytes[offset++] = (byte)(0xFFL & value >> 48);
        bytes[offset] = (byte)(0xFFL & value >> 56);
    }

    public static int getVarIntSize(int value) {
        int result = 0;
        do {
            ++result;
        } while ((value >>>= 7) != 0);
        return result;
    }

    public static int getVarLongSize(long value) {
        int result = 0;
        do {
            ++result;
        } while ((value >>>= 7) != 0L);
        return result;
    }

    public static int getVarInt(ByteBuffer buffer) {
        long result = 0L;
        int shift = 0;
        for (int i = 0; i < 9; ++i) {
            byte b = buffer.get();
            result |= (long)((b & 0x7F) << shift);
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return (int)result;
    }

    public static void setVarInt(ByteBuffer buffer, int value) {
        while ((value & 0xFFFFFF80) != 0) {
            buffer.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        buffer.put((byte)(value & 0x7F));
    }

    public static int readVarInt(InputStream input) throws IOException {
        long result = 0L;
        int shift = 0;
        for (int i = 0; i < 9; ++i) {
            int b = input.read();
            if (b == -1) {
                try {
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new EOFException();
            }
            result |= (long)((b & 0x7F) << shift);
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return (int)result;
    }

    public static void writeVarInt(OutputStream output, long value) throws IOException {
        for (int i = 0; i < 9; ++i) {
            byte b = (byte)(value & 0x7FL);
            if (value > 127L) {
                b = (byte)(b | 0x80);
            }
            output.write(b);
            if ((value >>= 7) != 0L) continue;
            return;
        }
    }

    protected ClickHouseByteUtils() {
    }
}

