/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.grpc.ClickHouseGrpcClientImpl;
import com.clickhouse.client.grpc.impl.Exception;
import com.clickhouse.client.grpc.impl.LogEntry;
import com.clickhouse.client.grpc.impl.Progress;
import com.clickhouse.client.grpc.impl.Result;
import com.clickhouse.client.grpc.impl.Stats;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@Deprecated
public class ClickHouseStreamObserver
implements StreamObserver<Result> {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseStreamObserver.class);
    private final ClickHouseNode server;
    private final AtomicBoolean started;
    private final AtomicBoolean completed;
    private final ClickHouseOutputStream stream;
    private final ClickHouseInputStream input;
    private final ClickHouseResponseSummary summary;
    private final AtomicReference<IOException> errorRef;

    protected ClickHouseStreamObserver(ClickHouseConfig config, ClickHouseNode server, ClickHouseOutputStream output) {
        this.server = server;
        this.started = new AtomicBoolean(false);
        this.completed = new AtomicBoolean(false);
        Runnable postCloseAction = () -> {
            IOException exp = this.getError();
            if (exp != null) {
                throw new UncheckedIOException(exp);
            }
        };
        if (output != null) {
            this.stream = output;
            this.input = ClickHouseInputStream.wrap(null, ClickHouseInputStream.empty(), config.getReadBufferSize(), ClickHouseCompression.NONE, -1, postCloseAction);
        } else {
            ClickHousePipedOutputStream pipedStream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(config);
            this.stream = pipedStream;
            this.input = ClickHouseGrpcClientImpl.getInput(config, pipedStream.getInputStream(), postCloseAction);
        }
        this.summary = new ClickHouseResponseSummary(null, null);
        this.errorRef = new AtomicReference<Object>(null);
    }

    protected void checkClosed() {
        if (this.completed.get()) {
            throw new IllegalStateException("closed observer");
        }
    }

    protected boolean updateStatus(Result result) {
        this.summary.update();
        if (log.isDebugEnabled()) {
            log.debug(() -> {
                for (LogEntry e : result.getLogsList()) {
                    String logLevel = e.getLevel().name();
                    int index = logLevel.indexOf(95);
                    if (index > 0) {
                        logLevel = logLevel.substring(index + 1);
                    }
                    log.info((Object)"%s.%s [ %s ] {%s} <%s> %s: %s", e.getTime(), e.getTimeMicroseconds(), e.getThreadId(), e.getQueryId(), logLevel, e.getSource(), e.getText());
                }
                return ClickHouseUtils.format("Logged %d entries from server", result.getLogsList().size());
            });
        }
        boolean proceed = true;
        if (result.hasStats()) {
            Stats s = result.getStats();
            this.summary.update(new ClickHouseResponseSummary.Statistics(s.getRows(), s.getBlocks(), s.getAllocatedBytes(), s.getAppliedLimit(), s.getRowsBeforeLimit()));
        }
        if (result.hasProgress()) {
            Progress p = result.getProgress();
            this.summary.update(new ClickHouseResponseSummary.Progress(p.getReadRows(), p.getReadBytes(), p.getTotalRowsToRead(), p.getWrittenRows(), p.getWrittenBytes()));
        }
        if (result.getCancelled()) {
            proceed = false;
            this.onError((Throwable)new StatusException(Status.CANCELLED));
        } else if (result.hasException()) {
            proceed = false;
            Exception e = result.getException();
            log.error((Object)"Server error: Code=%s, %s", e.getCode(), e.getDisplayText());
            log.error((Object)e.getStackTrace(), new Object[0]);
            Throwable error = this.errorRef.get();
            if (error == null) {
                this.errorRef.compareAndSet(null, new IOException(ClickHouseException.buildErrorMessage(result.getException().getCode(), result.getException().getDisplayText())));
            }
        }
        return proceed;
    }

    public boolean isCompleted() {
        return this.completed.get();
    }

    public boolean isCancelled() {
        return this.isCompleted() && this.errorRef.get() != null;
    }

    public ClickHouseResponseSummary getSummary() {
        return this.summary;
    }

    public IOException getError() {
        return this.errorRef.get();
    }

    public void onNext(Result value) {
        try {
            this.checkClosed();
            log.trace((Object)"Got result: %s", value);
            if (this.updateStatus(value)) {
                try {
                    this.stream.writeBytes(value.getOutput().toByteArray());
                }
                catch (IOException e) {
                    this.onError(e);
                }
            }
        }
        finally {
            this.started.compareAndSet(false, true);
        }
    }

    public void onError(Throwable t) {
        try {
            log.error((Object)"Query failed", t);
            if (!this.errorRef.compareAndSet(null, new IOException(t))) {
                log.warn((Object)"Overriding exception", this.errorRef.get());
            }
            try {
                log.debug((Object)("Closing output stream: " + this.stream), new Object[0]);
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.checkClosed();
        }
        finally {
            this.started.compareAndSet(false, true);
            this.completed.compareAndSet(false, true);
        }
    }

    public void onCompleted() {
        log.trace((Object)"Query finished", new Object[0]);
        try {
            this.stream.flush();
        }
        catch (IOException e) {
            this.errorRef.compareAndSet(null, e);
            log.error((Object)"Failed to flush output", e);
        }
        finally {
            this.started.compareAndSet(false, true);
            this.completed.compareAndSet(false, true);
            try {
                this.stream.close();
            }
            catch (IOException e) {
                log.warn((Object)"Failed to close output stream", e);
            }
        }
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return ClickHouseUtils.waitFor(this.started, timeout, unit);
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return ClickHouseUtils.waitFor(this.completed, timeout, unit);
    }

    public ClickHouseInputStream getInputStream() {
        return this.input;
    }
}

