/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.jdbc.AbstractResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;

public class CombinedResultSet
extends AbstractResultSet {
    private final ResultSet[] results;
    private int nextIndex = 0;
    private ResultSet current;
    private int rowNumber = 0;
    private boolean isClosed = false;

    protected ResultSet current() throws SQLException {
        if (this.current == null) {
            throw new SQLException("No result to access", "02000");
        }
        return this.current;
    }

    protected boolean hasNext() throws SQLException {
        if (this.current == null) {
            return false;
        }
        if (this.current.next()) {
            return true;
        }
        if (this.nextIndex >= this.results.length) {
            return false;
        }
        boolean hasNext = false;
        while (this.nextIndex < this.results.length) {
            if (this.current != null) {
                this.current.close();
            }
            this.current = this.results[this.nextIndex++];
            if (this.current == null || !this.current.next()) continue;
            hasNext = true;
            break;
        }
        return hasNext;
    }

    public CombinedResultSet(ResultSet ... results) {
        if (results == null || results.length == 0) {
            this.results = new ResultSet[0];
            this.current = null;
        } else {
            this.results = results;
            for (ResultSet rs : results) {
                ++this.nextIndex;
                if (this.current != null || rs == null) continue;
                this.current = rs;
                break;
            }
        }
    }

    public CombinedResultSet(Collection<ResultSet> results) {
        if (results == null || results.isEmpty()) {
            this.results = new ResultSet[0];
            this.current = null;
        } else {
            int len = results.size();
            this.results = new ResultSet[len];
            int i = 0;
            for (ResultSet rs : results) {
                this.results[i++] = rs;
                if (this.current != null || rs == null) continue;
                this.current = rs;
                this.nextIndex = i;
            }
            if (this.nextIndex == 0) {
                this.nextIndex = len;
            }
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.hasNext()) {
            ++this.rowNumber;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        for (ResultSet rs : this.results) {
            if (rs == null) continue;
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isClosed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.current().wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.current().getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.current().getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.current().getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.current().getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.current().getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.current().getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.current().getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.current().getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.current().getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.current().getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.current().getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.current().getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.current().getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.current().getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.current().getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.current().getBinaryStream(columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.current().getString(columnLabel);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.current().getBoolean(columnLabel);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.current().getByte(columnLabel);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.current().getShort(columnLabel);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.current().getInt(columnLabel);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.current().getLong(columnLabel);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.current().getFloat(columnLabel);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.current().getDouble(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.current().getBigDecimal(columnLabel, scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.current().getBytes(columnLabel);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.current().getDate(columnLabel);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.current().getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.current().getTimestamp(columnLabel);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.current().getAsciiStream(columnLabel);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.current().getUnicodeStream(columnLabel);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.current().getBinaryStream(columnLabel);
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.current().getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.current().getMetaData();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.current().getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.current().getObject(columnLabel);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.current().findColumn(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.current().getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.current().getCharacterStream(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.current().getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.current().getBigDecimal(columnLabel);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rowNumber == 0 && this.current().isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.nextIndex >= this.results.length) {
            return this.current().isAfterLast();
        }
        ResultSet rs = this.current();
        boolean isAfterLast = false;
        while ((isAfterLast = rs.isAfterLast()) && this.next()) {
            rs = this.current();
        }
        return isAfterLast;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rowNumber == 1 && this.current().isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.nextIndex >= this.results.length) {
            return this.current().isLast();
        }
        ResultSet rs = this.current();
        boolean isLast = false;
        while ((isLast = rs.isLast()) && this.next()) {
            rs = this.current();
        }
        return isLast;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowNumber;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.current().getFetchSize();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.current().rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.current().rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.current().rowDeleted();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.current().getStatement();
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.current().getObject(columnIndex, map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this.current().getRef(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.current().getBlob(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.current().getClob(columnIndex);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.current().getArray(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.current().getObject(columnLabel, map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.current().getRef(columnLabel);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.current().getBlob(columnLabel);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.current().getClob(columnLabel);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.current().getArray(columnLabel);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.current().getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.current().getDate(columnLabel, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.current().getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.current().getTime(columnLabel, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.current().getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.current().getTimestamp(columnLabel, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.current().getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.current().getURL(columnLabel);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.current().getRowId(columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.current().getRowId(columnLabel);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.current().getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.current().getNClob(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.current().getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.current().getSQLXML(columnLabel);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.current().getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.current().getNString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.current().getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.current().getNCharacterStream(columnLabel);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.current().getObject(columnIndex, type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.current().getObject(columnLabel, type);
    }
}

