/*
 * Decompiled with CFR 0.152.
 */
package com.codesnippets4all.json.config.handlers;

import com.codesnippets4all.json.config.handlers.ConfigHandler;
import com.codesnippets4all.json.exceptions.JSONConfigInitializationException;
import com.codesnippets4all.json.parsers.JSONParser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonConfigHandler
implements ConfigHandler {
    private Map configMap = null;
    private InputStream stream = null;
    private String encoding = "UTF-8";
    private JSONParser parser = null;

    @Override
    public void setStream(InputStream is) {
        this.stream = is;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setParserSelfInstance(JSONParser parser) {
        this.parser = parser;
    }

    @Override
    public void parse() {
        if (this.parser == null) {
            throw new JSONConfigInitializationException("JSON Parser instance is not initialized...is required to parser json based validation config....");
        }
        try {
            this.configMap = this.parser.parseJson(this.stream, this.encoding);
            this.transform();
        }
        catch (Exception e) {
            throw new JSONConfigInitializationException(e);
        }
        finally {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void transform() {
        Map rootMap = this.configMap;
        if (rootMap == null) {
            throw new JSONConfigInitializationException("validation configuration is not available...");
        }
        StringBuilder temp = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> tempMap = null;
        this.configMap = new HashMap();
        for (String rootKey : rootMap.keySet()) {
            Map rootValueMap = (Map)rootMap.get(rootKey);
            tempMap = new HashMap<String, String>();
            for (Map.Entry entry : rootValueMap.entrySet()) {
                String name = (String)entry.getKey();
                Map valueMap = (Map)entry.getValue();
                sb.delete(0, sb.length());
                sb.append(name).append("~~");
                for (Map.Entry ent : valueMap.entrySet()) {
                    String key = (String)ent.getKey();
                    String value = (String)ent.getValue();
                    temp.delete(0, temp.length());
                    tempMap.put(temp.append((CharSequence)sb).append(key).toString(), value);
                }
            }
            this.configMap.put(rootKey, tempMap);
        }
        rootMap.clear();
        rootMap = null;
    }

    @Override
    public HashMap<String, String> getPatternMap(String path) {
        HashMap<String, String> patternMap = (HashMap<String, String>)this.configMap.get(path);
        if (patternMap == null) {
            patternMap = new HashMap<String, String>();
            patternMap.put("default~~valueType", "STRING_LITERAL");
        }
        return patternMap;
    }
}

