/*
 * Decompiled with CFR 0.152.
 */
package com.codesnippets4all.json.config.handlers;

import com.codesnippets4all.json.config.handlers.ConfigHandler;
import com.codesnippets4all.json.exceptions.JSONConfigInitializationException;
import com.codesnippets4all.json.parsers.JSONParser;
import com.codesnippets4all.json.utils.CachedInstances;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfigHandler
extends DefaultHandler
implements ConfigHandler {
    private Map<String, HashMap<String, String>> configMap = new HashMap<String, HashMap<String, String>>(6, 0.5f);
    private HashMap<String, String> tempMap = new HashMap();
    private InputStream stream = null;
    private String encoding = "UTF-8";

    @Override
    public void setStream(InputStream is) {
        this.stream = is;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void parse() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.stream, (DefaultHandler)this);
        }
        catch (Exception e) {
            throw new JSONConfigInitializationException(e);
        }
        finally {
            this.tempMap = null;
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public HashMap<String, String> getPatternMap(String path) {
        HashMap<String, String> patternMap = this.configMap.get(path);
        if (patternMap == null) {
            patternMap = new HashMap();
            patternMap.put("default~~valueType", "STRING_LITERAL");
        }
        return patternMap;
    }

    @Override
    public void startElement(String arg0, String arg1, String arg2, Attributes attrib) throws SAXException {
        if (arg2.equalsIgnoreCase("KeyValue")) {
            String name = attrib.getValue("name");
            String index = attrib.getValue("index");
            if (name == null && index == null) {
                throw new JSONConfigInitializationException("Either name or index attribute is mandatory for KeyValue tag element...");
            }
            name = name == null ? index : name;
            String key = name + "~~";
            this.tempMap.put(key + "keyPattern", attrib.getValue("keyPattern"));
            this.tempMap.put(key + "valuePattern", attrib.getValue("valuePattern"));
            this.tempMap.put(key + "valueType", attrib.getValue("valueType"));
            this.tempMap.put(key + "keyValidator", attrib.getValue("keyValidator"));
            this.tempMap.put(key + "valueValidator", attrib.getValue("valueValidator"));
        } else if (arg2.equalsIgnoreCase("json-heirarchy")) {
            HashMap<String, String> patternMap = this.configMap.get(attrib.getValue("path"));
            if (patternMap == null) {
                patternMap = new HashMap();
                this.configMap.put(attrib.getValue("path"), patternMap);
            }
            this.tempMap = patternMap;
        } else if (arg2.equalsIgnoreCase("custom-validator")) {
            CachedInstances.getInstance().loadAndCacheInstance(attrib.getValue("alias"), attrib.getValue("class"));
        }
    }

    @Override
    public void setParserSelfInstance(JSONParser parser) {
    }
}

