/*
 * Decompiled with CFR 0.152.
 */
package com.codesnippets4all.json.generators;

import com.codesnippets4all.json.serializers.ArraySerializer;
import com.codesnippets4all.json.serializers.ClassSerializer;
import com.codesnippets4all.json.serializers.DateSerializer;
import com.codesnippets4all.json.serializers.JsonSerializer;
import com.codesnippets4all.json.serializers.ListSerializer;
import com.codesnippets4all.json.serializers.MapSerializer;
import com.codesnippets4all.json.serializers.NumberSerializer;
import com.codesnippets4all.json.serializers.PropertiesSerializer;
import com.codesnippets4all.json.serializers.SetSerializer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class JSONGenerator {
    private static JsonSerializer arraySerializer = new ArraySerializer();
    private static JsonSerializer classSerializer = new ClassSerializer();
    private static JsonSerializer dateSerializer = new DateSerializer();
    private static JsonSerializer listSerializer = new ListSerializer();
    private static JsonSerializer mapSerializer = new MapSerializer();
    private static JsonSerializer propertiesSerializer = new PropertiesSerializer();
    private static JsonSerializer setSerializer = new SetSerializer();
    private static JsonSerializer numberSerializer = new NumberSerializer();

    public String generateJson(Object toBeSerialized) {
        if (toBeSerialized == null) {
            return "{}";
        }
        StringBuilder jsonStr = new StringBuilder();
        this.process(toBeSerialized, jsonStr);
        return jsonStr.toString();
    }

    private void process(Object toBeSerialized, StringBuilder jsonStr) {
        jsonStr.append('[');
        JSONGenerator.traverseObjects(toBeSerialized, jsonStr, true);
        jsonStr.append(']');
    }

    public static boolean traverseObjects(Object toBeSerialized, StringBuilder jsonStr, boolean isArrayAllowed) {
        boolean flag = false;
        if (toBeSerialized == null) {
            jsonStr.append("NULL");
        } else if (toBeSerialized instanceof CharSequence) {
            jsonStr.append('\"').append(toBeSerialized).append('\"');
        } else if (toBeSerialized instanceof Number) {
            numberSerializer.serialize(toBeSerialized, jsonStr, null);
        } else if (toBeSerialized instanceof Date) {
            dateSerializer.serialize(toBeSerialized, jsonStr, null);
        } else if (toBeSerialized instanceof Boolean) {
            jsonStr.append(toBeSerialized.toString());
        } else if (toBeSerialized instanceof Set) {
            flag = true;
            if (isArrayAllowed) {
                setSerializer.serialize(toBeSerialized, jsonStr, null);
            }
        } else if (toBeSerialized instanceof List) {
            flag = true;
            if (isArrayAllowed) {
                listSerializer.serialize(toBeSerialized, jsonStr, null);
            }
        } else if (toBeSerialized instanceof Map) {
            mapSerializer.serialize(toBeSerialized, jsonStr, null);
        } else if (toBeSerialized instanceof Properties) {
            propertiesSerializer.serialize(toBeSerialized, jsonStr, null);
        } else if (toBeSerialized.getClass().isArray()) {
            flag = true;
            if (isArrayAllowed) {
                arraySerializer.serialize(toBeSerialized, jsonStr, null);
            }
        } else {
            classSerializer.serialize(toBeSerialized, jsonStr, null);
        }
        return flag;
    }
}

