/*
 * Decompiled with CFR 0.152.
 */
package com.codesnippets4all.json.serializers;

import com.codesnippets4all.json.exceptions.SerializingException;
import com.codesnippets4all.json.generators.JSONGenerator;
import com.codesnippets4all.json.serializers.JsonSerializer;
import com.codesnippets4all.json.serializers.pojos.SerializerOptions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ClassSerializer
implements JsonSerializer {
    public void serialize(Object toBeSerialized, StringBuilder serializedData, SerializerOptions options) {
        try {
            Class<?> clazz = toBeSerialized.getClass();
            Field[] fields = clazz.getDeclaredFields();
            serializedData.append('{');
            for (Field field : fields) {
                int modifier = field.getModifiers();
                serializedData.append('\"').append(field.getName()).append('\"').append(':');
                if (Modifier.isPrivate(modifier)) {
                    field.setAccessible(true);
                }
                Object obj = null;
                try {
                    obj = field.get(toBeSerialized);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                JSONGenerator.traverseObjects(obj, serializedData, true);
                serializedData.append(',');
            }
            serializedData.append('}');
        }
        catch (Exception e) {
            throw new SerializingException("Unexpected failure while serializing the object....");
        }
    }
}

