/*
 * Decompiled with CFR 0.152.
 */
package com.codesnippets4all.json.serializers;

import com.codesnippets4all.json.exceptions.SerializingException;
import com.codesnippets4all.json.generators.JSONGenerator;
import com.codesnippets4all.json.serializers.JsonSerializer;
import com.codesnippets4all.json.serializers.pojos.SerializerOptions;
import java.util.Map;
import java.util.Set;

public class MapSerializer
implements JsonSerializer {
    public void serialize(Object toBeSerialized, StringBuilder serializedData, SerializerOptions options) {
        if (toBeSerialized == null || !(toBeSerialized instanceof Map)) {
            throw new SerializingException("input object is not an instance of map");
        }
        serializedData.append('{');
        Set entrySet = ((Map)toBeSerialized).entrySet();
        for (Map.Entry entry : entrySet) {
            String key = String.valueOf(entry.getKey());
            serializedData.append('\"').append(key).append('\"').append(':');
            Object value = entry.getValue();
            JSONGenerator.traverseObjects(value, serializedData, true);
            serializedData.append(',');
        }
        serializedData.deleteCharAt(serializedData.length() - 1);
        serializedData.append('}');
    }
}

