/*
 * Decompiled with CFR 0.152.
 */
package com.codesnippets4all.json.serializers;

import com.codesnippets4all.json.exceptions.SerializingException;
import com.codesnippets4all.json.serializers.JsonSerializer;
import com.codesnippets4all.json.serializers.pojos.SerializerOptions;

public class NumberSerializer
implements JsonSerializer {
    public void serialize(Object toBeSerialized, StringBuilder serializedData, SerializerOptions options) {
        if (!(toBeSerialized instanceof Number)) {
            throw new SerializingException("input object is not of type number...");
        }
        if (toBeSerialized instanceof Double) {
            double doubleVal = (Double)toBeSerialized;
            if (Double.isNaN(doubleVal) || Double.isInfinite(doubleVal)) {
                throw new SerializingException("invalid Double type value..." + toBeSerialized);
            }
            serializedData.append(doubleVal);
        } else if (toBeSerialized instanceof Float) {
            float floatVal = ((Float)toBeSerialized).floatValue();
            if (Float.isNaN(floatVal) || Float.isInfinite(floatVal)) {
                throw new SerializingException("invalid Float type value..." + toBeSerialized);
            }
            serializedData.append(floatVal);
        } else {
            serializedData.append(toBeSerialized);
        }
    }
}

