/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.slice.api.injector;

import com.cognifide.slice.api.injector.InjectorCreationFailListener;
import com.cognifide.slice.api.injector.InjectorRunner;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class InjectorConfig {
    public static final String DEFAULT_INJECTOR_PATH = "/apps/";
    private final List<Module> modules;
    private final String name;
    private final String applicationPath;
    private final String parentName;
    private final String basePackage;
    private final String bundleFilter;
    private final InjectorCreationFailListener listener;

    InjectorConfig(InjectorRunner runner) {
        this.modules = Collections.unmodifiableList(new ArrayList<Module>(runner.getModules()));
        this.name = runner.getInjectorName();
        this.applicationPath = StringUtils.defaultIfEmpty((String)runner.getApplicationPath(), (String)(DEFAULT_INJECTOR_PATH + this.name));
        this.parentName = runner.getParentName();
        this.basePackage = runner.getBasePackage();
        this.bundleFilter = runner.getBundleNameFilter();
        this.listener = runner;
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public boolean hasParent() {
        return StringUtils.isNotBlank((String)this.parentName);
    }

    public List<? extends Module> getModules() {
        return this.modules;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getBundleNameFilter() {
        return this.bundleFilter;
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public InjectorCreationFailListener getListener() {
        return this.listener;
    }
}

