/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.slice.api.injector;

import com.cognifide.slice.api.injector.InjectorConfig;
import com.cognifide.slice.api.injector.InjectorCreationFailListener;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectorRunner
implements InjectorCreationFailListener {
    private static final Logger LOG = LoggerFactory.getLogger(InjectorRunner.class);
    private final String injectorName;
    private final List<Module> modules = new ArrayList<Module>();
    private final BundleContext bundleContext;
    private final String bundleNameFilter;
    private final String basePackage;
    private boolean started = false;
    private String parentInjectorName;
    private String applicationPath;
    private boolean injectorCreationSuccess = true;

    public InjectorRunner(BundleContext bundleContext, String injectorName, String applicationPath, String bundleNameFilter, String basePackage) {
        this(bundleContext, injectorName, bundleNameFilter, basePackage);
        this.applicationPath = applicationPath;
    }

    public InjectorRunner(BundleContext bundleContext, String injectorName, String bundleNameFilter, String basePackage) {
        this.bundleContext = bundleContext;
        this.injectorName = injectorName;
        this.bundleNameFilter = bundleNameFilter;
        this.basePackage = basePackage;
    }

    public void setParentInjectorName(String parentInjectorName) {
        this.parentInjectorName = parentInjectorName;
    }

    public void installModule(Module newModule) {
        if (this.started) {
            throw new IllegalStateException("Installing new modules is not allowed after Injector was stared");
        }
        this.modules.add(newModule);
    }

    public void installModules(List<? extends Module> newModules) {
        if (this.started) {
            throw new IllegalStateException("Installing new modules is not allowed after Injector was stared");
        }
        this.modules.addAll(newModules);
    }

    @Override
    public void creationFailed() {
        try {
            this.injectorCreationSuccess = false;
            this.started = false;
            this.bundleContext.getBundle().stop();
        }
        catch (BundleException e) {
            LOG.error("InjectorRunner failed to stop the bundle on injector creation failure", (Throwable)e);
        }
    }

    public void start() throws BundleException {
        InjectorConfig config = new InjectorConfig(this);
        Hashtable properties = new Hashtable();
        this.bundleContext.registerService(InjectorConfig.class.getName(), (Object)config, properties);
        if (!this.injectorCreationSuccess) {
            this.started = false;
            throw new BundleException("Failed to create an injector", 5);
        }
        this.started = true;
    }

    public String getInjectorName() {
        return this.injectorName;
    }

    String getBundleNameFilter() {
        return this.bundleNameFilter;
    }

    String getBasePackage() {
        return this.basePackage;
    }

    List<? extends Module> getModules() {
        return this.modules;
    }

    String getParentName() {
        return this.parentInjectorName;
    }

    String getApplicationPath() {
        return this.applicationPath;
    }
}

